@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.HubArgs.builder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.HubBillingInfoFormatArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.HubBillingInfoFormatArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Hub resource.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * ## Example Usage
 * ### Hubs_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hub = new AzureNative.CustomerInsights.Hub("hub", new()
 *     {
 *         HubBillingInfo = new AzureNative.CustomerInsights.Inputs.HubBillingInfoFormatArgs
 *         {
 *             MaxUnits = 5,
 *             MinUnits = 1,
 *             SkuName = "B0",
 *         },
 *         HubName = "sdkTestHub",
 *         Location = "West US",
 *         ResourceGroupName = "TestHubRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewHub(ctx, "hub", &customerinsights.HubArgs{
 * 			HubBillingInfo: &customerinsights.HubBillingInfoFormatArgs{
 * 				MaxUnits: pulumi.Int(5),
 * 				MinUnits: pulumi.Int(1),
 * 				SkuName:  pulumi.String("B0"),
 * 			},
 * 			HubName:           pulumi.String("sdkTestHub"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("TestHubRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.Hub;
 * import com.pulumi.azurenative.customerinsights.HubArgs;
 * import com.pulumi.azurenative.customerinsights.inputs.HubBillingInfoFormatArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hub = new Hub("hub", HubArgs.builder()
 *             .hubBillingInfo(HubBillingInfoFormatArgs.builder()
 *                 .maxUnits(5)
 *                 .minUnits(1)
 *                 .skuName("B0")
 *                 .build())
 *             .hubName("sdkTestHub")
 *             .location("West US")
 *             .resourceGroupName("TestHubRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:Hub testHub2839 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}
 * ```
 * @property hubBillingInfo Billing settings of the hub.
 * @property hubName The name of the Hub.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 * @property tenantFeatures The bit flags for enabled hub features. Bit 0 is set to 1 indicates graph is enabled, or disabled if set to 0. Bit 1 is set to 1 indicates the hub is disabled, or enabled if set to 0.
 */
public data class HubArgs(
    public val hubBillingInfo: Output<HubBillingInfoFormatArgs>? = null,
    public val hubName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tenantFeatures: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.HubArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.HubArgs =
        com.pulumi.azurenative.customerinsights.HubArgs.builder()
            .hubBillingInfo(hubBillingInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hubName(hubName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tenantFeatures(tenantFeatures?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HubArgs].
 */
@PulumiTagMarker
public class HubArgsBuilder internal constructor() {
    private var hubBillingInfo: Output<HubBillingInfoFormatArgs>? = null

    private var hubName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tenantFeatures: Output<Int>? = null

    /**
     * @param value Billing settings of the hub.
     */
    @JvmName("hgyekrxftylfvxbd")
    public suspend fun hubBillingInfo(`value`: Output<HubBillingInfoFormatArgs>) {
        this.hubBillingInfo = value
    }

    /**
     * @param value The name of the Hub.
     */
    @JvmName("xibpwmuoohocttjr")
    public suspend fun hubName(`value`: Output<String>) {
        this.hubName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("awbjsfwseadducbw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ofioexjuowouatko")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lvwwijtjxoyqljww")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The bit flags for enabled hub features. Bit 0 is set to 1 indicates graph is enabled, or disabled if set to 0. Bit 1 is set to 1 indicates the hub is disabled, or enabled if set to 0.
     */
    @JvmName("jwmyuedxfahjainm")
    public suspend fun tenantFeatures(`value`: Output<Int>) {
        this.tenantFeatures = value
    }

    /**
     * @param value Billing settings of the hub.
     */
    @JvmName("opxspulaygecktlm")
    public suspend fun hubBillingInfo(`value`: HubBillingInfoFormatArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubBillingInfo = mapped
    }

    /**
     * @param argument Billing settings of the hub.
     */
    @JvmName("axoiuxmbunjxqsfc")
    public suspend fun hubBillingInfo(argument: suspend HubBillingInfoFormatArgsBuilder.() -> Unit) {
        val toBeMapped = HubBillingInfoFormatArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hubBillingInfo = mapped
    }

    /**
     * @param value The name of the Hub.
     */
    @JvmName("bqlnfjmpypahuvug")
    public suspend fun hubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("erfhgfnvnmmffbok")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("mcbljbhskvnnpgas")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gorrvwkdmllxkhby")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ygpaoaxhsrbyqnlg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The bit flags for enabled hub features. Bit 0 is set to 1 indicates graph is enabled, or disabled if set to 0. Bit 1 is set to 1 indicates the hub is disabled, or enabled if set to 0.
     */
    @JvmName("myoebuwngoeforkq")
    public suspend fun tenantFeatures(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantFeatures = mapped
    }

    internal fun build(): HubArgs = HubArgs(
        hubBillingInfo = hubBillingInfo,
        hubName = hubName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        tenantFeatures = tenantFeatures,
    )
}
