@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.LinkArgs.builder
import com.pulumi.azurenative.customerinsights.kotlin.enums.EntityType
import com.pulumi.azurenative.customerinsights.kotlin.enums.InstanceOperationType
import com.pulumi.azurenative.customerinsights.kotlin.inputs.ParticipantPropertyReferenceArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.ParticipantPropertyReferenceArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.TypePropertiesMappingArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.TypePropertiesMappingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The link resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * Other available API versions: 2017-01-01.
 * ## Example Usage
 * ### Links_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var link = new AzureNative.CustomerInsights.Link("link", new()
 *     {
 *         Description =
 *         {
 *             { "en-us", "Link Description" },
 *         },
 *         DisplayName =
 *         {
 *             { "en-us", "Link DisplayName" },
 *         },
 *         HubName = "sdkTestHub",
 *         LinkName = "linkTest4806",
 *         Mappings = new[]
 *         {
 *             new AzureNative.CustomerInsights.Inputs.TypePropertiesMappingArgs
 *             {
 *                 LinkType = AzureNative.CustomerInsights.LinkTypes.UpdateAlways,
 *                 SourcePropertyName = "testInteraction1949",
 *                 TargetPropertyName = "testProfile1446",
 *             },
 *         },
 *         ParticipantPropertyReferences = new[]
 *         {
 *             new AzureNative.CustomerInsights.Inputs.ParticipantPropertyReferenceArgs
 *             {
 *                 SourcePropertyName = "testInteraction1949",
 *                 TargetPropertyName = "ProfileId",
 *             },
 *         },
 *         ResourceGroupName = "TestHubRG",
 *         SourceEntityType = AzureNative.CustomerInsights.EntityType.Interaction,
 *         SourceEntityTypeName = "testInteraction1949",
 *         TargetEntityType = AzureNative.CustomerInsights.EntityType.Profile,
 *         TargetEntityTypeName = "testProfile1446",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewLink(ctx, "link", &customerinsights.LinkArgs{
 * 			Description: pulumi.StringMap{
 * 				"en-us": pulumi.String("Link Description"),
 * 			},
 * 			DisplayName: pulumi.StringMap{
 * 				"en-us": pulumi.String("Link DisplayName"),
 * 			},
 * 			HubName:  pulumi.String("sdkTestHub"),
 * 			LinkName: pulumi.String("linkTest4806"),
 * 			Mappings: customerinsights.TypePropertiesMappingArray{
 * 				&customerinsights.TypePropertiesMappingArgs{
 * 					LinkType:           customerinsights.LinkTypesUpdateAlways,
 * 					SourcePropertyName: pulumi.String("testInteraction1949"),
 * 					TargetPropertyName: pulumi.String("testProfile1446"),
 * 				},
 * 			},
 * 			ParticipantPropertyReferences: customerinsights.ParticipantPropertyReferenceArray{
 * 				&customerinsights.ParticipantPropertyReferenceArgs{
 * 					SourcePropertyName: pulumi.String("testInteraction1949"),
 * 					TargetPropertyName: pulumi.String("ProfileId"),
 * 				},
 * 			},
 * 			ResourceGroupName:    pulumi.String("TestHubRG"),
 * 			SourceEntityType:     customerinsights.EntityTypeInteraction,
 * 			SourceEntityTypeName: pulumi.String("testInteraction1949"),
 * 			TargetEntityType:     customerinsights.EntityTypeProfile,
 * 			TargetEntityTypeName: pulumi.String("testProfile1446"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.Link;
 * import com.pulumi.azurenative.customerinsights.LinkArgs;
 * import com.pulumi.azurenative.customerinsights.inputs.TypePropertiesMappingArgs;
 * import com.pulumi.azurenative.customerinsights.inputs.ParticipantPropertyReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var link = new Link("link", LinkArgs.builder()
 *             .description(Map.of("en-us", "Link Description"))
 *             .displayName(Map.of("en-us", "Link DisplayName"))
 *             .hubName("sdkTestHub")
 *             .linkName("linkTest4806")
 *             .mappings(TypePropertiesMappingArgs.builder()
 *                 .linkType("UpdateAlways")
 *                 .sourcePropertyName("testInteraction1949")
 *                 .targetPropertyName("testProfile1446")
 *                 .build())
 *             .participantPropertyReferences(ParticipantPropertyReferenceArgs.builder()
 *                 .sourcePropertyName("testInteraction1949")
 *                 .targetPropertyName("ProfileId")
 *                 .build())
 *             .resourceGroupName("TestHubRG")
 *             .sourceEntityType("Interaction")
 *             .sourceEntityTypeName("testInteraction1949")
 *             .targetEntityType("Profile")
 *             .targetEntityTypeName("testProfile1446")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:Link azSdkTestHub/linkTest4806 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/links/{linkName}
 * ```
 * @property description Localized descriptions for the Link.
 * @property displayName Localized display name for the Link.
 * @property hubName The name of the hub.
 * @property linkName The name of the link.
 * @property mappings The set of properties mappings between the source and target Types.
 * @property operationType Determines whether this link is supposed to create or delete instances if Link is NOT Reference Only.
 * @property participantPropertyReferences The properties that represent the participating profile.
 * @property referenceOnly Indicating whether the link is reference only link. This flag is ignored if the Mappings are defined. If the mappings are not defined and it is set to true, links processing will not create or update profiles.
 * @property resourceGroupName The name of the resource group.
 * @property sourceEntityType Type of source entity.
 * @property sourceEntityTypeName Name of the source Entity Type.
 * @property targetEntityType Type of target entity.
 * @property targetEntityTypeName Name of the target Entity Type.
 */
public data class LinkArgs(
    public val description: Output<Map<String, String>>? = null,
    public val displayName: Output<Map<String, String>>? = null,
    public val hubName: Output<String>? = null,
    public val linkName: Output<String>? = null,
    public val mappings: Output<List<TypePropertiesMappingArgs>>? = null,
    public val operationType: Output<InstanceOperationType>? = null,
    public val participantPropertyReferences: Output<List<ParticipantPropertyReferenceArgs>>? = null,
    public val referenceOnly: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sourceEntityType: Output<EntityType>? = null,
    public val sourceEntityTypeName: Output<String>? = null,
    public val targetEntityType: Output<EntityType>? = null,
    public val targetEntityTypeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.LinkArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.LinkArgs =
        com.pulumi.azurenative.customerinsights.LinkArgs.builder()
            .description(
                description?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .displayName(
                displayName?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .hubName(hubName?.applyValue({ args0 -> args0 }))
            .linkName(linkName?.applyValue({ args0 -> args0 }))
            .mappings(
                mappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .operationType(operationType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .participantPropertyReferences(
                participantPropertyReferences?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .referenceOnly(referenceOnly?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sourceEntityType(sourceEntityType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceEntityTypeName(sourceEntityTypeName?.applyValue({ args0 -> args0 }))
            .targetEntityType(targetEntityType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetEntityTypeName(targetEntityTypeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkArgs].
 */
@PulumiTagMarker
public class LinkArgsBuilder internal constructor() {
    private var description: Output<Map<String, String>>? = null

    private var displayName: Output<Map<String, String>>? = null

    private var hubName: Output<String>? = null

    private var linkName: Output<String>? = null

    private var mappings: Output<List<TypePropertiesMappingArgs>>? = null

    private var operationType: Output<InstanceOperationType>? = null

    private var participantPropertyReferences: Output<List<ParticipantPropertyReferenceArgs>>? = null

    private var referenceOnly: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    private var sourceEntityType: Output<EntityType>? = null

    private var sourceEntityTypeName: Output<String>? = null

    private var targetEntityType: Output<EntityType>? = null

    private var targetEntityTypeName: Output<String>? = null

    /**
     * @param value Localized descriptions for the Link.
     */
    @JvmName("grlviuatktqofgco")
    public suspend fun description(`value`: Output<Map<String, String>>) {
        this.description = value
    }

    /**
     * @param value Localized display name for the Link.
     */
    @JvmName("wprxxwiqvwlmdvhl")
    public suspend fun displayName(`value`: Output<Map<String, String>>) {
        this.displayName = value
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("epfafijehcauxgcy")
    public suspend fun hubName(`value`: Output<String>) {
        this.hubName = value
    }

    /**
     * @param value The name of the link.
     */
    @JvmName("pakgpdyytcjcvnqv")
    public suspend fun linkName(`value`: Output<String>) {
        this.linkName = value
    }

    /**
     * @param value The set of properties mappings between the source and target Types.
     */
    @JvmName("fjgmwpeglndytpsx")
    public suspend fun mappings(`value`: Output<List<TypePropertiesMappingArgs>>) {
        this.mappings = value
    }

    @JvmName("alnqnffkylcqoeym")
    public suspend fun mappings(vararg values: Output<TypePropertiesMappingArgs>) {
        this.mappings = Output.all(values.asList())
    }

    /**
     * @param values The set of properties mappings between the source and target Types.
     */
    @JvmName("kiaeenlsxjhpnvqd")
    public suspend fun mappings(values: List<Output<TypePropertiesMappingArgs>>) {
        this.mappings = Output.all(values)
    }

    /**
     * @param value Determines whether this link is supposed to create or delete instances if Link is NOT Reference Only.
     */
    @JvmName("mvtmdwpawgprdjci")
    public suspend fun operationType(`value`: Output<InstanceOperationType>) {
        this.operationType = value
    }

    /**
     * @param value The properties that represent the participating profile.
     */
    @JvmName("cpidbrytyoixqclg")
    public suspend fun participantPropertyReferences(`value`: Output<List<ParticipantPropertyReferenceArgs>>) {
        this.participantPropertyReferences = value
    }

    @JvmName("vhsskfyqnvygfihy")
    public suspend fun participantPropertyReferences(vararg values: Output<ParticipantPropertyReferenceArgs>) {
        this.participantPropertyReferences = Output.all(values.asList())
    }

    /**
     * @param values The properties that represent the participating profile.
     */
    @JvmName("wqiinedheiqpnwbi")
    public suspend fun participantPropertyReferences(values: List<Output<ParticipantPropertyReferenceArgs>>) {
        this.participantPropertyReferences = Output.all(values)
    }

    /**
     * @param value Indicating whether the link is reference only link. This flag is ignored if the Mappings are defined. If the mappings are not defined and it is set to true, links processing will not create or update profiles.
     */
    @JvmName("muudecqphxrnpgie")
    public suspend fun referenceOnly(`value`: Output<Boolean>) {
        this.referenceOnly = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("dkynrjmdkeseskyo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Type of source entity.
     */
    @JvmName("gclabgunxdiktjxd")
    public suspend fun sourceEntityType(`value`: Output<EntityType>) {
        this.sourceEntityType = value
    }

    /**
     * @param value Name of the source Entity Type.
     */
    @JvmName("lnvslvcfomykwlfn")
    public suspend fun sourceEntityTypeName(`value`: Output<String>) {
        this.sourceEntityTypeName = value
    }

    /**
     * @param value Type of target entity.
     */
    @JvmName("qyqdurxvjekmbdeq")
    public suspend fun targetEntityType(`value`: Output<EntityType>) {
        this.targetEntityType = value
    }

    /**
     * @param value Name of the target Entity Type.
     */
    @JvmName("qrtphpyhkdkwqucp")
    public suspend fun targetEntityTypeName(`value`: Output<String>) {
        this.targetEntityTypeName = value
    }

    /**
     * @param value Localized descriptions for the Link.
     */
    @JvmName("fueumimbtetqfdvh")
    public suspend fun description(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param values Localized descriptions for the Link.
     */
    @JvmName("dqcbukybsaugkgtb")
    public fun description(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Localized display name for the Link.
     */
    @JvmName("ccqopxvddaoixjtf")
    public suspend fun displayName(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param values Localized display name for the Link.
     */
    @JvmName("ackhlxdwntbaadmt")
    public fun displayName(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("avvstycmmqxkuvfu")
    public suspend fun hubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubName = mapped
    }

    /**
     * @param value The name of the link.
     */
    @JvmName("nqkqrcofegsbukug")
    public suspend fun linkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkName = mapped
    }

    /**
     * @param value The set of properties mappings between the source and target Types.
     */
    @JvmName("lrfuchbvsoqpogpy")
    public suspend fun mappings(`value`: List<TypePropertiesMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mappings = mapped
    }

    /**
     * @param argument The set of properties mappings between the source and target Types.
     */
    @JvmName("rggnlagmakvqjmxb")
    public suspend fun mappings(argument: List<suspend TypePropertiesMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TypePropertiesMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mappings = mapped
    }

    /**
     * @param argument The set of properties mappings between the source and target Types.
     */
    @JvmName("ypcxntsvklpcoapx")
    public suspend fun mappings(vararg argument: suspend TypePropertiesMappingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TypePropertiesMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mappings = mapped
    }

    /**
     * @param argument The set of properties mappings between the source and target Types.
     */
    @JvmName("bkblwbcufpvfutnh")
    public suspend fun mappings(argument: suspend TypePropertiesMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TypePropertiesMappingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.mappings = mapped
    }

    /**
     * @param values The set of properties mappings between the source and target Types.
     */
    @JvmName("vwqkykvsxeuwlrud")
    public suspend fun mappings(vararg values: TypePropertiesMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mappings = mapped
    }

    /**
     * @param value Determines whether this link is supposed to create or delete instances if Link is NOT Reference Only.
     */
    @JvmName("kyninrbnaojsikfs")
    public suspend fun operationType(`value`: InstanceOperationType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationType = mapped
    }

    /**
     * @param value The properties that represent the participating profile.
     */
    @JvmName("dwgcaxolxynprxpw")
    public suspend fun participantPropertyReferences(`value`: List<ParticipantPropertyReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.participantPropertyReferences = mapped
    }

    /**
     * @param argument The properties that represent the participating profile.
     */
    @JvmName("fuasuygajhqpjpml")
    public suspend fun participantPropertyReferences(argument: List<suspend ParticipantPropertyReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ParticipantPropertyReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.participantPropertyReferences = mapped
    }

    /**
     * @param argument The properties that represent the participating profile.
     */
    @JvmName("tlsallmlslwglbnh")
    public suspend fun participantPropertyReferences(vararg argument: suspend ParticipantPropertyReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ParticipantPropertyReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.participantPropertyReferences = mapped
    }

    /**
     * @param argument The properties that represent the participating profile.
     */
    @JvmName("rihtasjdtqcfgdbn")
    public suspend fun participantPropertyReferences(argument: suspend ParticipantPropertyReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ParticipantPropertyReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.participantPropertyReferences = mapped
    }

    /**
     * @param values The properties that represent the participating profile.
     */
    @JvmName("tpsuckkjhgjjgdwq")
    public suspend fun participantPropertyReferences(vararg values: ParticipantPropertyReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.participantPropertyReferences = mapped
    }

    /**
     * @param value Indicating whether the link is reference only link. This flag is ignored if the Mappings are defined. If the mappings are not defined and it is set to true, links processing will not create or update profiles.
     */
    @JvmName("oxkegtpeyowixpuu")
    public suspend fun referenceOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referenceOnly = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xvhhhdhjgruckcap")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Type of source entity.
     */
    @JvmName("fmwdlqhtmluxeurl")
    public suspend fun sourceEntityType(`value`: EntityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEntityType = mapped
    }

    /**
     * @param value Name of the source Entity Type.
     */
    @JvmName("qkibaqohxbfxydbx")
    public suspend fun sourceEntityTypeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEntityTypeName = mapped
    }

    /**
     * @param value Type of target entity.
     */
    @JvmName("gxnmqaeurrhxflaw")
    public suspend fun targetEntityType(`value`: EntityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetEntityType = mapped
    }

    /**
     * @param value Name of the target Entity Type.
     */
    @JvmName("perqqrkuopihgmxe")
    public suspend fun targetEntityTypeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetEntityTypeName = mapped
    }

    internal fun build(): LinkArgs = LinkArgs(
        description = description,
        displayName = displayName,
        hubName = hubName,
        linkName = linkName,
        mappings = mappings,
        operationType = operationType,
        participantPropertyReferences = participantPropertyReferences,
        referenceOnly = referenceOnly,
        resourceGroupName = resourceGroupName,
        sourceEntityType = sourceEntityType,
        sourceEntityTypeName = sourceEntityTypeName,
        targetEntityType = targetEntityType,
        targetEntityTypeName = targetEntityTypeName,
    )
}
