@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.kotlin.outputs.PropertyDefinitionResponse
import com.pulumi.azurenative.customerinsights.kotlin.outputs.StrongIdResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.customerinsights.kotlin.outputs.PropertyDefinitionResponse.Companion.toKotlin as propertyDefinitionResponseToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.StrongIdResponse.Companion.toKotlin as strongIdResponseToKotlin

/**
 * Builder for [Profile].
 */
@PulumiTagMarker
public class ProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProfileArgs = ProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProfileArgsBuilder.() -> Unit) {
        val builder = ProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Profile {
        val builtJavaResource = com.pulumi.azurenative.customerinsights.Profile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Profile(builtJavaResource)
    }
}

/**
 * The profile resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * ## Example Usage
 * ### Profiles_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var profile = new AzureNative.CustomerInsights.Profile("profile", new()
 *     {
 *         ApiEntitySetName = "TestProfileType396",
 *         Fields = new[]
 *         {
 *             new AzureNative.CustomerInsights.Inputs.PropertyDefinitionArgs
 *             {
 *                 FieldName = "Id",
 *                 FieldType = "Edm.String",
 *                 IsArray = false,
 *                 IsRequired = true,
 *             },
 *             new AzureNative.CustomerInsights.Inputs.PropertyDefinitionArgs
 *             {
 *                 FieldName = "ProfileId",
 *                 FieldType = "Edm.String",
 *                 IsArray = false,
 *                 IsRequired = true,
 *             },
 *             new AzureNative.CustomerInsights.Inputs.PropertyDefinitionArgs
 *             {
 *                 FieldName = "LastName",
 *                 FieldType = "Edm.String",
 *                 IsArray = false,
 *                 IsRequired = true,
 *             },
 *             new AzureNative.CustomerInsights.Inputs.PropertyDefinitionArgs
 *             {
 *                 FieldName = "TestProfileType396",
 *                 FieldType = "Edm.String",
 *                 IsArray = false,
 *                 IsRequired = true,
 *             },
 *             new AzureNative.CustomerInsights.Inputs.PropertyDefinitionArgs
 *             {
 *                 FieldName = "SavingAccountBalance",
 *                 FieldType = "Edm.Int32",
 *                 IsArray = false,
 *                 IsRequired = true,
 *             },
 *         },
 *         HubName = "sdkTestHub",
 *         LargeImage = "\\\\Images\\\\LargeImage",
 *         MediumImage = "\\\\Images\\\\MediumImage",
 *         ProfileName = "TestProfileType396",
 *         ResourceGroupName = "TestHubRG",
 *         SchemaItemTypeLink = "SchemaItemTypeLink",
 *         SmallImage = "\\\\Images\\\\smallImage",
 *         StrongIds = new[]
 *         {
 *             new AzureNative.CustomerInsights.Inputs.StrongIdArgs
 *             {
 *                 KeyPropertyNames = new[]
 *                 {
 *                     "Id",
 *                     "SavingAccountBalance",
 *                 },
 *                 StrongIdName = "Id",
 *             },
 *             new AzureNative.CustomerInsights.Inputs.StrongIdArgs
 *             {
 *                 KeyPropertyNames = new[]
 *                 {
 *                     "ProfileId",
 *                     "LastName",
 *                 },
 *                 StrongIdName = "ProfileId",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewProfile(ctx, "profile", &customerinsights.ProfileArgs{
 * 			ApiEntitySetName: pulumi.String("TestProfileType396"),
 * 			Fields: customerinsights.PropertyDefinitionArray{
 * 				&customerinsights.PropertyDefinitionArgs{
 * 					FieldName:  pulumi.String("Id"),
 * 					FieldType:  pulumi.String("Edm.String"),
 * 					IsArray:    pulumi.Bool(false),
 * 					IsRequired: pulumi.Bool(true),
 * 				},
 * 				&customerinsights.PropertyDefinitionArgs{
 * 					FieldName:  pulumi.String("ProfileId"),
 * 					FieldType:  pulumi.String("Edm.String"),
 * 					IsArray:    pulumi.Bool(false),
 * 					IsRequired: pulumi.Bool(true),
 * 				},
 * 				&customerinsights.PropertyDefinitionArgs{
 * 					FieldName:  pulumi.String("LastName"),
 * 					FieldType:  pulumi.String("Edm.String"),
 * 					IsArray:    pulumi.Bool(false),
 * 					IsRequired: pulumi.Bool(true),
 * 				},
 * 				&customerinsights.PropertyDefinitionArgs{
 * 					FieldName:  pulumi.String("TestProfileType396"),
 * 					FieldType:  pulumi.String("Edm.String"),
 * 					IsArray:    pulumi.Bool(false),
 * 					IsRequired: pulumi.Bool(true),
 * 				},
 * 				&customerinsights.PropertyDefinitionArgs{
 * 					FieldName:  pulumi.String("SavingAccountBalance"),
 * 					FieldType:  pulumi.String("Edm.Int32"),
 * 					IsArray:    pulumi.Bool(false),
 * 					IsRequired: pulumi.Bool(true),
 * 				},
 * 			},
 * 			HubName:            pulumi.String("sdkTestHub"),
 * 			LargeImage:         pulumi.String("\\\\Images\\\\LargeImage"),
 * 			MediumImage:        pulumi.String("\\\\Images\\\\MediumImage"),
 * 			ProfileName:        pulumi.String("TestProfileType396"),
 * 			ResourceGroupName:  pulumi.String("TestHubRG"),
 * 			SchemaItemTypeLink: pulumi.String("SchemaItemTypeLink"),
 * 			SmallImage:         pulumi.String("\\\\Images\\\\smallImage"),
 * 			StrongIds: customerinsights.StrongIdArray{
 * 				&customerinsights.StrongIdArgs{
 * 					KeyPropertyNames: pulumi.StringArray{
 * 						pulumi.String("Id"),
 * 						pulumi.String("SavingAccountBalance"),
 * 					},
 * 					StrongIdName: pulumi.String("Id"),
 * 				},
 * 				&customerinsights.StrongIdArgs{
 * 					KeyPropertyNames: pulumi.StringArray{
 * 						pulumi.String("ProfileId"),
 * 						pulumi.String("LastName"),
 * 					},
 * 					StrongIdName: pulumi.String("ProfileId"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.Profile;
 * import com.pulumi.azurenative.customerinsights.ProfileArgs;
 * import com.pulumi.azurenative.customerinsights.inputs.PropertyDefinitionArgs;
 * import com.pulumi.azurenative.customerinsights.inputs.StrongIdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var profile = new Profile("profile", ProfileArgs.builder()
 *             .apiEntitySetName("TestProfileType396")
 *             .fields(
 *                 PropertyDefinitionArgs.builder()
 *                     .fieldName("Id")
 *                     .fieldType("Edm.String")
 *                     .isArray(false)
 *                     .isRequired(true)
 *                     .build(),
 *                 PropertyDefinitionArgs.builder()
 *                     .fieldName("ProfileId")
 *                     .fieldType("Edm.String")
 *                     .isArray(false)
 *                     .isRequired(true)
 *                     .build(),
 *                 PropertyDefinitionArgs.builder()
 *                     .fieldName("LastName")
 *                     .fieldType("Edm.String")
 *                     .isArray(false)
 *                     .isRequired(true)
 *                     .build(),
 *                 PropertyDefinitionArgs.builder()
 *                     .fieldName("TestProfileType396")
 *                     .fieldType("Edm.String")
 *                     .isArray(false)
 *                     .isRequired(true)
 *                     .build(),
 *                 PropertyDefinitionArgs.builder()
 *                     .fieldName("SavingAccountBalance")
 *                     .fieldType("Edm.Int32")
 *                     .isArray(false)
 *                     .isRequired(true)
 *                     .build())
 *             .hubName("sdkTestHub")
 *             .largeImage("\\\\Images\\\\LargeImage")
 *             .mediumImage("\\\\Images\\\\MediumImage")
 *             .profileName("TestProfileType396")
 *             .resourceGroupName("TestHubRG")
 *             .schemaItemTypeLink("SchemaItemTypeLink")
 *             .smallImage("\\\\Images\\\\smallImage")
 *             .strongIds(
 *                 StrongIdArgs.builder()
 *                     .keyPropertyNames(
 *                         "Id",
 *                         "SavingAccountBalance")
 *                     .strongIdName("Id")
 *                     .build(),
 *                 StrongIdArgs.builder()
 *                     .keyPropertyNames(
 *                         "ProfileId",
 *                         "LastName")
 *                     .strongIdName("ProfileId")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:Profile azSdkTestHub/TestProfileType396 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/profiles/{profileName}
 * ```
 */
public class Profile internal constructor(
    override val javaResource: com.pulumi.azurenative.customerinsights.Profile,
) : KotlinCustomResource(javaResource, ProfileMapper) {
    /**
     * The api entity set name. This becomes the odata entity set name for the entity Type being referred in this object.
     */
    public val apiEntitySetName: Output<String>?
        get() = javaResource.apiEntitySetName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The attributes for the Type.
     */
    public val attributes: Output<Map<String, List<String>>>?
        get() = javaResource.attributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value.map({ args0 -> args0 }))
                }).toMap()
            }).orElse(null)
        })

    /**
     * Localized descriptions for the property.
     */
    public val description: Output<Map<String, String>>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Localized display names for the property.
     */
    public val displayName: Output<Map<String, String>>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Type of entity.
     */
    public val entityType: Output<String>?
        get() = javaResource.entityType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The properties of the Profile.
     */
    public val fields: Output<List<PropertyDefinitionResponse>>?
        get() = javaResource.fields().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> propertyDefinitionResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The instance count.
     */
    public val instancesCount: Output<Int>?
        get() = javaResource.instancesCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Large Image associated with the Property or EntityType.
     */
    public val largeImage: Output<String>?
        get() = javaResource.largeImage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The last changed time for the type definition.
     */
    public val lastChangedUtc: Output<String>
        get() = javaResource.lastChangedUtc().applyValue({ args0 -> args0 })

    /**
     * Any custom localized attributes for the Type.
     */
    public val localizedAttributes: Output<Map<String, Map<String, String>>>?
        get() = javaResource.localizedAttributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.map({ args0 ->
                            args0.key.to(args0.value)
                        }).toMap(),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * Medium Image associated with the Property or EntityType.
     */
    public val mediumImage: Output<String>?
        get() = javaResource.mediumImage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The schema org link. This helps ACI identify and suggest semantic models.
     */
    public val schemaItemTypeLink: Output<String>?
        get() = javaResource.schemaItemTypeLink().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Small Image associated with the Property or EntityType.
     */
    public val smallImage: Output<String>?
        get() = javaResource.smallImage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The strong IDs.
     */
    public val strongIds: Output<List<StrongIdResponse>>?
        get() = javaResource.strongIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> strongIdResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The hub name.
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    /**
     * The timestamp property name. Represents the time when the interaction or profile update happened.
     */
    public val timestampFieldName: Output<String>?
        get() = javaResource.timestampFieldName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The name of the entity.
     */
    public val typeName: Output<String>?
        get() = javaResource.typeName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ProfileMapper : ResourceMapper<Profile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.customerinsights.Profile::class == javaResource::class

    override fun map(javaResource: Resource): Profile = Profile(
        javaResource as
            com.pulumi.azurenative.customerinsights.Profile,
    )
}

/**
 * @see [Profile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Profile].
 */
public suspend fun profile(name: String, block: suspend ProfileResourceBuilder.() -> Unit): Profile {
    val builder = ProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Profile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun profile(name: String): Profile {
    val builder = ProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
