@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Determines whether this link is supposed to create or delete instances if Link is NOT Reference Only.
 */
public enum class InstanceOperationType(
    public val javaValue: com.pulumi.azurenative.customerinsights.enums.InstanceOperationType,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.enums.InstanceOperationType> {
    Upsert(com.pulumi.azurenative.customerinsights.enums.InstanceOperationType.Upsert),
    Delete(com.pulumi.azurenative.customerinsights.enums.InstanceOperationType.Delete),
    ;

    override fun toJava(): com.pulumi.azurenative.customerinsights.enums.InstanceOperationType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.enums.InstanceOperationType): InstanceOperationType = InstanceOperationType.values().first { it.javaValue == javaType }
    }
}
