@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.AssignmentPrincipalArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The AssignmentPrincipal
 * @property principalId The principal id being assigned to.
 * @property principalMetadata Other metadata for the principal.
 * @property principalType The Type of the principal ID.
 */
public data class AssignmentPrincipalArgs(
    public val principalId: Output<String>,
    public val principalMetadata: Output<Map<String, String>>? = null,
    public val principalType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.AssignmentPrincipalArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.AssignmentPrincipalArgs =
        com.pulumi.azurenative.customerinsights.inputs.AssignmentPrincipalArgs.builder()
            .principalId(principalId.applyValue({ args0 -> args0 }))
            .principalMetadata(
                principalMetadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .principalType(principalType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssignmentPrincipalArgs].
 */
@PulumiTagMarker
public class AssignmentPrincipalArgsBuilder internal constructor() {
    private var principalId: Output<String>? = null

    private var principalMetadata: Output<Map<String, String>>? = null

    private var principalType: Output<String>? = null

    /**
     * @param value The principal id being assigned to.
     */
    @JvmName("fjdovmmudgausrrd")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value Other metadata for the principal.
     */
    @JvmName("pfnfrxgswdephobl")
    public suspend fun principalMetadata(`value`: Output<Map<String, String>>) {
        this.principalMetadata = value
    }

    /**
     * @param value The Type of the principal ID.
     */
    @JvmName("djlsybwrtesdwehm")
    public suspend fun principalType(`value`: Output<String>) {
        this.principalType = value
    }

    /**
     * @param value The principal id being assigned to.
     */
    @JvmName("nncbhpwbudepwoju")
    public suspend fun principalId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value Other metadata for the principal.
     */
    @JvmName("oaembgjxqacidblq")
    public suspend fun principalMetadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalMetadata = mapped
    }

    /**
     * @param values Other metadata for the principal.
     */
    @JvmName("ijfplsddeikvgair")
    public fun principalMetadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalMetadata = mapped
    }

    /**
     * @param value The Type of the principal ID.
     */
    @JvmName("shfludvehonsbaal")
    public suspend fun principalType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    internal fun build(): AssignmentPrincipalArgs = AssignmentPrincipalArgs(
        principalId = principalId ?: throw PulumiNullFieldException("principalId"),
        principalMetadata = principalMetadata,
        principalType = principalType ?: throw PulumiNullFieldException("principalType"),
    )
}
