@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingAvailabilityArgs.builder
import com.pulumi.azurenative.customerinsights.kotlin.enums.FrequencyTypes
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Connector mapping property availability.
 * @property frequency The frequency to update.
 * @property interval The interval of the given frequency to use.
 */
public data class ConnectorMappingAvailabilityArgs(
    public val frequency: Output<FrequencyTypes>? = null,
    public val interval: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingAvailabilityArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingAvailabilityArgs =
        com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingAvailabilityArgs.builder()
            .frequency(frequency?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .interval(interval.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorMappingAvailabilityArgs].
 */
@PulumiTagMarker
public class ConnectorMappingAvailabilityArgsBuilder internal constructor() {
    private var frequency: Output<FrequencyTypes>? = null

    private var interval: Output<Int>? = null

    /**
     * @param value The frequency to update.
     */
    @JvmName("pidmumbwslptjdlw")
    public suspend fun frequency(`value`: Output<FrequencyTypes>) {
        this.frequency = value
    }

    /**
     * @param value The interval of the given frequency to use.
     */
    @JvmName("jicraackdyrqvdlk")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value The frequency to update.
     */
    @JvmName("ujxktmfuxnvhknqu")
    public suspend fun frequency(`value`: FrequencyTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value The interval of the given frequency to use.
     */
    @JvmName("vcemunhojxrrqmjq")
    public suspend fun interval(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    internal fun build(): ConnectorMappingAvailabilityArgs = ConnectorMappingAvailabilityArgs(
        frequency = frequency,
        interval = interval ?: throw PulumiNullFieldException("interval"),
    )
}
