@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingCompleteOperationArgs.builder
import com.pulumi.azurenative.customerinsights.kotlin.enums.CompletionOperationTypes
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The complete operation.
 * @property completionOperationType The type of completion operation.
 * @property destinationFolder The destination folder where files will be moved to once the import is done.
 */
public data class ConnectorMappingCompleteOperationArgs(
    public val completionOperationType: Output<CompletionOperationTypes>? = null,
    public val destinationFolder: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingCompleteOperationArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingCompleteOperationArgs =
        com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingCompleteOperationArgs.builder()
            .completionOperationType(
                completionOperationType?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .destinationFolder(destinationFolder?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorMappingCompleteOperationArgs].
 */
@PulumiTagMarker
public class ConnectorMappingCompleteOperationArgsBuilder internal constructor() {
    private var completionOperationType: Output<CompletionOperationTypes>? = null

    private var destinationFolder: Output<String>? = null

    /**
     * @param value The type of completion operation.
     */
    @JvmName("sxwulgbayxiwvynw")
    public suspend fun completionOperationType(`value`: Output<CompletionOperationTypes>) {
        this.completionOperationType = value
    }

    /**
     * @param value The destination folder where files will be moved to once the import is done.
     */
    @JvmName("yqwaqjkftlcnvaiw")
    public suspend fun destinationFolder(`value`: Output<String>) {
        this.destinationFolder = value
    }

    /**
     * @param value The type of completion operation.
     */
    @JvmName("bwpdwosgkkskjtuj")
    public suspend fun completionOperationType(`value`: CompletionOperationTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.completionOperationType = mapped
    }

    /**
     * @param value The destination folder where files will be moved to once the import is done.
     */
    @JvmName("sscnhsdiqgkboyif")
    public suspend fun destinationFolder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationFolder = mapped
    }

    internal fun build(): ConnectorMappingCompleteOperationArgs =
        ConnectorMappingCompleteOperationArgs(
            completionOperationType = completionOperationType,
            destinationFolder = destinationFolder,
        )
}
