@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.GetConnectorMappingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectorName The name of the connector.
 * @property hubName The name of the hub.
 * @property mappingName The name of the connector mapping.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetConnectorMappingPlainArgs(
    public val connectorName: String,
    public val hubName: String,
    public val mappingName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.GetConnectorMappingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.GetConnectorMappingPlainArgs = com.pulumi.azurenative.customerinsights.inputs.GetConnectorMappingPlainArgs.builder()
        .connectorName(connectorName.let({ args0 -> args0 }))
        .hubName(hubName.let({ args0 -> args0 }))
        .mappingName(mappingName.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectorMappingPlainArgs].
 */
@PulumiTagMarker
public class GetConnectorMappingPlainArgsBuilder internal constructor() {
    private var connectorName: String? = null

    private var hubName: String? = null

    private var mappingName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the connector.
     */
    @JvmName("nvgxvjkswmdxrmcy")
    public suspend fun connectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectorName = mapped
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("nushapigykierley")
    public suspend fun hubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hubName = mapped
    }

    /**
     * @param value The name of the connector mapping.
     */
    @JvmName("baffdmklykynjuty")
    public suspend fun mappingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mappingName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("afhvvwmkvwrulmnp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConnectorMappingPlainArgs = GetConnectorMappingPlainArgs(
        connectorName = connectorName ?: throw PulumiNullFieldException("connectorName"),
        hubName = hubName ?: throw PulumiNullFieldException("hubName"),
        mappingName = mappingName ?: throw PulumiNullFieldException("mappingName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
