@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.PredictionMappingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Definition of the link mapping of prediction.
 * @property grade The grade of the link mapping.
 * @property reason The reason of the link mapping.
 * @property score The score of the link mapping.
 */
public data class PredictionMappingsArgs(
    public val grade: Output<String>,
    public val reason: Output<String>,
    public val score: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.PredictionMappingsArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.PredictionMappingsArgs =
        com.pulumi.azurenative.customerinsights.inputs.PredictionMappingsArgs.builder()
            .grade(grade.applyValue({ args0 -> args0 }))
            .reason(reason.applyValue({ args0 -> args0 }))
            .score(score.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PredictionMappingsArgs].
 */
@PulumiTagMarker
public class PredictionMappingsArgsBuilder internal constructor() {
    private var grade: Output<String>? = null

    private var reason: Output<String>? = null

    private var score: Output<String>? = null

    /**
     * @param value The grade of the link mapping.
     */
    @JvmName("osoxuotuwvcaspgv")
    public suspend fun grade(`value`: Output<String>) {
        this.grade = value
    }

    /**
     * @param value The reason of the link mapping.
     */
    @JvmName("hswoexbivoarghyx")
    public suspend fun reason(`value`: Output<String>) {
        this.reason = value
    }

    /**
     * @param value The score of the link mapping.
     */
    @JvmName("oosxdvphsusledri")
    public suspend fun score(`value`: Output<String>) {
        this.score = value
    }

    /**
     * @param value The grade of the link mapping.
     */
    @JvmName("hnegottceenyatao")
    public suspend fun grade(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.grade = mapped
    }

    /**
     * @param value The reason of the link mapping.
     */
    @JvmName("bymetxgefxsmgdqx")
    public suspend fun reason(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reason = mapped
    }

    /**
     * @param value The score of the link mapping.
     */
    @JvmName("slphqskhgxcittec")
    public suspend fun score(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.score = mapped
    }

    internal fun build(): PredictionMappingsArgs = PredictionMappingsArgs(
        grade = grade ?: throw PulumiNullFieldException("grade"),
        reason = reason ?: throw PulumiNullFieldException("reason"),
        score = score ?: throw PulumiNullFieldException("score"),
    )
}
