@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.ProfileEnumValidValuesFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Valid enum values in case of an enum property.
 * @property localizedValueNames Localized names of the enum member.
 * @property value The integer value of the enum member.
 */
public data class ProfileEnumValidValuesFormatArgs(
    public val localizedValueNames: Output<Map<String, String>>? = null,
    public val `value`: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.ProfileEnumValidValuesFormatArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.ProfileEnumValidValuesFormatArgs =
        com.pulumi.azurenative.customerinsights.inputs.ProfileEnumValidValuesFormatArgs.builder()
            .localizedValueNames(
                localizedValueNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProfileEnumValidValuesFormatArgs].
 */
@PulumiTagMarker
public class ProfileEnumValidValuesFormatArgsBuilder internal constructor() {
    private var localizedValueNames: Output<Map<String, String>>? = null

    private var `value`: Output<Int>? = null

    /**
     * @param value Localized names of the enum member.
     */
    @JvmName("ruonadrcchlenqlq")
    public suspend fun localizedValueNames(`value`: Output<Map<String, String>>) {
        this.localizedValueNames = value
    }

    /**
     * @param value The integer value of the enum member.
     */
    @JvmName("hbixilcbkmbkgnab")
    public suspend fun `value`(`value`: Output<Int>) {
        this.`value` = value
    }

    /**
     * @param value Localized names of the enum member.
     */
    @JvmName("poouegmlunddaoth")
    public suspend fun localizedValueNames(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localizedValueNames = mapped
    }

    /**
     * @param values Localized names of the enum member.
     */
    @JvmName("lpjcerseuynvusdr")
    public fun localizedValueNames(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localizedValueNames = mapped
    }

    /**
     * @param value The integer value of the enum member.
     */
    @JvmName("hlbrtpgrbtbrlvjl")
    public suspend fun `value`(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ProfileEnumValidValuesFormatArgs = ProfileEnumValidValuesFormatArgs(
        localizedValueNames = localizedValueNames,
        `value` = `value`,
    )
}
