@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.StrongIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Property/Properties which represent a unique ID.
 * @property description Localized descriptions.
 * @property displayName Localized display name.
 * @property keyPropertyNames The properties which make up the unique ID.
 * @property strongIdName The Name identifying the strong ID.
 */
public data class StrongIdArgs(
    public val description: Output<Map<String, String>>? = null,
    public val displayName: Output<Map<String, String>>? = null,
    public val keyPropertyNames: Output<List<String>>,
    public val strongIdName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.StrongIdArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.StrongIdArgs =
        com.pulumi.azurenative.customerinsights.inputs.StrongIdArgs.builder()
            .description(
                description?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .displayName(
                displayName?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .keyPropertyNames(keyPropertyNames.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .strongIdName(strongIdName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StrongIdArgs].
 */
@PulumiTagMarker
public class StrongIdArgsBuilder internal constructor() {
    private var description: Output<Map<String, String>>? = null

    private var displayName: Output<Map<String, String>>? = null

    private var keyPropertyNames: Output<List<String>>? = null

    private var strongIdName: Output<String>? = null

    /**
     * @param value Localized descriptions.
     */
    @JvmName("ykroenircbxobunl")
    public suspend fun description(`value`: Output<Map<String, String>>) {
        this.description = value
    }

    /**
     * @param value Localized display name.
     */
    @JvmName("imqocsphtjywwaon")
    public suspend fun displayName(`value`: Output<Map<String, String>>) {
        this.displayName = value
    }

    /**
     * @param value The properties which make up the unique ID.
     */
    @JvmName("mnnygcungxtbfftk")
    public suspend fun keyPropertyNames(`value`: Output<List<String>>) {
        this.keyPropertyNames = value
    }

    @JvmName("akgkaeknfmvnctma")
    public suspend fun keyPropertyNames(vararg values: Output<String>) {
        this.keyPropertyNames = Output.all(values.asList())
    }

    /**
     * @param values The properties which make up the unique ID.
     */
    @JvmName("axoduqvkxrwkgcyc")
    public suspend fun keyPropertyNames(values: List<Output<String>>) {
        this.keyPropertyNames = Output.all(values)
    }

    /**
     * @param value The Name identifying the strong ID.
     */
    @JvmName("jliubigvmyykwkfe")
    public suspend fun strongIdName(`value`: Output<String>) {
        this.strongIdName = value
    }

    /**
     * @param value Localized descriptions.
     */
    @JvmName("sqxvksaewdcepywn")
    public suspend fun description(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param values Localized descriptions.
     */
    @JvmName("riqedhrnluvkjkrf")
    public fun description(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Localized display name.
     */
    @JvmName("reyfsrhtnnjvgnjb")
    public suspend fun displayName(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param values Localized display name.
     */
    @JvmName("htbyoepdtnhmcbbh")
    public fun displayName(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The properties which make up the unique ID.
     */
    @JvmName("mwhfcerjrqskurdp")
    public suspend fun keyPropertyNames(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyPropertyNames = mapped
    }

    /**
     * @param values The properties which make up the unique ID.
     */
    @JvmName("nmecmcdtqadqnkvd")
    public suspend fun keyPropertyNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyPropertyNames = mapped
    }

    /**
     * @param value The Name identifying the strong ID.
     */
    @JvmName("qpdkgwbigwvswaix")
    public suspend fun strongIdName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.strongIdName = mapped
    }

    internal fun build(): StrongIdArgs = StrongIdArgs(
        description = description,
        displayName = displayName,
        keyPropertyNames = keyPropertyNames ?: throw PulumiNullFieldException("keyPropertyNames"),
        strongIdName = strongIdName ?: throw PulumiNullFieldException("strongIdName"),
    )
}
