@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The AssignmentPrincipal
 * @property principalId The principal id being assigned to.
 * @property principalMetadata Other metadata for the principal.
 * @property principalType The Type of the principal ID.
 */
public data class AssignmentPrincipalResponse(
    public val principalId: String,
    public val principalMetadata: Map<String, String>? = null,
    public val principalType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.AssignmentPrincipalResponse): AssignmentPrincipalResponse = AssignmentPrincipalResponse(
            principalId = javaType.principalId(),
            principalMetadata = javaType.principalMetadata().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            principalType = javaType.principalType(),
        )
    }
}
