@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * Definition of canonical profile.
 * @property canonicalProfileId Canonical profile ID.
 * @property properties Properties of the canonical profile.
 */
public data class CanonicalProfileDefinitionResponse(
    public val canonicalProfileId: Int? = null,
    public val properties: List<CanonicalProfileDefinitionResponseProperties>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.CanonicalProfileDefinitionResponse): CanonicalProfileDefinitionResponse = CanonicalProfileDefinitionResponse(
            canonicalProfileId = javaType.canonicalProfileId().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.CanonicalProfileDefinitionResponseProperties.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
