@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The definition of a canonical profile property.
 * @property profileName Profile name.
 * @property profilePropertyName Property name of profile.
 * @property rank The rank.
 * @property type Type of canonical property value.
 * @property value Value of the canonical property.
 */
public data class CanonicalProfileDefinitionResponseProperties(
    public val profileName: String? = null,
    public val profilePropertyName: String? = null,
    public val rank: Int? = null,
    public val type: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.CanonicalProfileDefinitionResponseProperties): CanonicalProfileDefinitionResponseProperties = CanonicalProfileDefinitionResponseProperties(
            profileName = javaType.profileName().map({ args0 -> args0 }).orElse(null),
            profilePropertyName = javaType.profilePropertyName().map({ args0 -> args0 }).orElse(null),
            rank = javaType.rank().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
