@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The complete operation.
 * @property completionOperationType The type of completion operation.
 * @property destinationFolder The destination folder where files will be moved to once the import is done.
 */
public data class ConnectorMappingCompleteOperationResponse(
    public val completionOperationType: String? = null,
    public val destinationFolder: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.ConnectorMappingCompleteOperationResponse): ConnectorMappingCompleteOperationResponse = ConnectorMappingCompleteOperationResponse(
            completionOperationType = javaType.completionOperationType().map({ args0 -> args0 }).orElse(null),
            destinationFolder = javaType.destinationFolder().map({ args0 -> args0 }).orElse(null),
        )
    }
}
