@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The error management.
 * @property errorLimit The error limit allowed while importing data.
 * @property errorManagementType The type of error management to use for the mapping.
 */
public data class ConnectorMappingErrorManagementResponse(
    public val errorLimit: Int? = null,
    public val errorManagementType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.ConnectorMappingErrorManagementResponse): ConnectorMappingErrorManagementResponse = ConnectorMappingErrorManagementResponse(
            errorLimit = javaType.errorLimit().map({ args0 -> args0 }).orElse(null),
            errorManagementType = javaType.errorManagementType(),
        )
    }
}
