@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The connector mapping properties.
 * @property availability The availability of mapping property.
 * @property completeOperation The operation after import is done.
 * @property errorManagement The error management setting for the mapping.
 * @property fileFilter The file filter for the mapping.
 * @property folderPath The folder path for the mapping.
 * @property format The format of mapping property.
 * @property hasHeader If the file contains a header or not.
 * @property structure Ingestion mapping information at property level.
 */
public data class ConnectorMappingPropertiesResponse(
    public val availability: ConnectorMappingAvailabilityResponse,
    public val completeOperation: ConnectorMappingCompleteOperationResponse,
    public val errorManagement: ConnectorMappingErrorManagementResponse,
    public val fileFilter: String? = null,
    public val folderPath: String? = null,
    public val format: ConnectorMappingFormatResponse,
    public val hasHeader: Boolean? = null,
    public val structure: List<ConnectorMappingStructureResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.ConnectorMappingPropertiesResponse): ConnectorMappingPropertiesResponse = ConnectorMappingPropertiesResponse(
            availability = javaType.availability().let({ args0 ->
                com.pulumi.azurenative.customerinsights.kotlin.outputs.ConnectorMappingAvailabilityResponse.Companion.toKotlin(args0)
            }),
            completeOperation = javaType.completeOperation().let({ args0 ->
                com.pulumi.azurenative.customerinsights.kotlin.outputs.ConnectorMappingCompleteOperationResponse.Companion.toKotlin(args0)
            }),
            errorManagement = javaType.errorManagement().let({ args0 ->
                com.pulumi.azurenative.customerinsights.kotlin.outputs.ConnectorMappingErrorManagementResponse.Companion.toKotlin(args0)
            }),
            fileFilter = javaType.fileFilter().map({ args0 -> args0 }).orElse(null),
            folderPath = javaType.folderPath().map({ args0 -> args0 }).orElse(null),
            format = javaType.format().let({ args0 ->
                com.pulumi.azurenative.customerinsights.kotlin.outputs.ConnectorMappingFormatResponse.Companion.toKotlin(args0)
            }),
            hasHeader = javaType.hasHeader().map({ args0 -> args0 }).orElse(null),
            structure = javaType.structure().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.ConnectorMappingStructureResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
