@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Connector mapping property structure.
 * @property columnName The column name of the import file.
 * @property customFormatSpecifier Custom format specifier for input parsing.
 * @property isEncrypted Indicates if the column is encrypted.
 * @property propertyName The property name of the mapping entity.
 */
public data class ConnectorMappingStructureResponse(
    public val columnName: String,
    public val customFormatSpecifier: String? = null,
    public val isEncrypted: Boolean? = null,
    public val propertyName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.ConnectorMappingStructureResponse): ConnectorMappingStructureResponse = ConnectorMappingStructureResponse(
            columnName = javaType.columnName(),
            customFormatSpecifier = javaType.customFormatSpecifier().map({ args0 -> args0 }).orElse(null),
            isEncrypted = javaType.isEncrypted().map({ args0 -> args0 }).orElse(null),
            propertyName = javaType.propertyName(),
        )
    }
}
