@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The data source precedence is a way to know the precedence of each data source.
 * @property dataSourceReferenceId The data source reference id.
 * @property dataSourceType The data source type.
 * @property id The data source ID.
 * @property name The data source name
 * @property precedence the precedence value.
 * @property status The data source status.
 */
public data class DataSourcePrecedenceResponse(
    public val dataSourceReferenceId: String,
    public val dataSourceType: String,
    public val id: Int,
    public val name: String,
    public val precedence: Int? = null,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.DataSourcePrecedenceResponse): DataSourcePrecedenceResponse = DataSourcePrecedenceResponse(
            dataSourceReferenceId = javaType.dataSourceReferenceId(),
            dataSourceType = javaType.dataSourceType(),
            id = javaType.id(),
            name = javaType.name(),
            precedence = javaType.precedence().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
        )
    }
}
