@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Hub resource.
 * @property apiEndpoint API endpoint URL of the hub.
 * @property hubBillingInfo Billing settings of the hub.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState Provisioning state of the hub.
 * @property tags Resource tags.
 * @property tenantFeatures The bit flags for enabled hub features. Bit 0 is set to 1 indicates graph is enabled, or disabled if set to 0. Bit 1 is set to 1 indicates the hub is disabled, or enabled if set to 0.
 * @property type Resource type.
 * @property webEndpoint Web endpoint URL of the hub.
 */
public data class GetHubResult(
    public val apiEndpoint: String,
    public val hubBillingInfo: HubBillingInfoFormatResponse? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val tenantFeatures: Int? = null,
    public val type: String,
    public val webEndpoint: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.GetHubResult): GetHubResult = GetHubResult(
            apiEndpoint = javaType.apiEndpoint(),
            hubBillingInfo = javaType.hubBillingInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.HubBillingInfoFormatResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tenantFeatures = javaType.tenantFeatures().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            webEndpoint = javaType.webEndpoint(),
        )
    }
}
