@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The KPI resource format.
 * @property aliases The aliases.
 * @property calculationWindow The calculation window.
 * @property calculationWindowFieldName Name of calculation window field.
 * @property description Localized description for the KPI.
 * @property displayName Localized display name for the KPI.
 * @property entityType The mapping entity type.
 * @property entityTypeName The mapping entity name.
 * @property expression The computation expression for the KPI.
 * @property extracts The KPI extracts.
 * @property filter The filter expression for the KPI.
 * @property function The computation function for the KPI.
 * @property groupBy the group by properties for the KPI.
 * @property groupByMetadata The KPI GroupByMetadata.
 * @property id Resource ID.
 * @property kpiName The KPI name.
 * @property name Resource name.
 * @property participantProfilesMetadata The participant profiles.
 * @property provisioningState Provisioning state.
 * @property tenantId The hub name.
 * @property thresHolds The KPI thresholds.
 * @property type Resource type.
 * @property unit The unit of measurement for the KPI.
 */
public data class GetKpiResult(
    public val aliases: List<KpiAliasResponse>? = null,
    public val calculationWindow: String,
    public val calculationWindowFieldName: String? = null,
    public val description: Map<String, String>? = null,
    public val displayName: Map<String, String>? = null,
    public val entityType: String,
    public val entityTypeName: String,
    public val expression: String,
    public val extracts: List<KpiExtractResponse>? = null,
    public val filter: String? = null,
    public val function: String,
    public val groupBy: List<String>? = null,
    public val groupByMetadata: List<KpiGroupByMetadataResponse>,
    public val id: String,
    public val kpiName: String,
    public val name: String,
    public val participantProfilesMetadata: List<KpiParticipantProfilesMetadataResponse>,
    public val provisioningState: String,
    public val tenantId: String,
    public val thresHolds: KpiThresholdsResponse? = null,
    public val type: String,
    public val unit: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.GetKpiResult): GetKpiResult = GetKpiResult(
            aliases = javaType.aliases().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.KpiAliasResponse.Companion.toKotlin(args0)
                })
            }),
            calculationWindow = javaType.calculationWindow(),
            calculationWindowFieldName = javaType.calculationWindowFieldName().map({ args0 ->
                args0
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            displayName = javaType.displayName().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            entityType = javaType.entityType(),
            entityTypeName = javaType.entityTypeName(),
            expression = javaType.expression(),
            extracts = javaType.extracts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.KpiExtractResponse.Companion.toKotlin(args0)
                })
            }),
            filter = javaType.filter().map({ args0 -> args0 }).orElse(null),
            function = javaType.function(),
            groupBy = javaType.groupBy().map({ args0 -> args0 }),
            groupByMetadata = javaType.groupByMetadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.KpiGroupByMetadataResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            kpiName = javaType.kpiName(),
            name = javaType.name(),
            participantProfilesMetadata = javaType.participantProfilesMetadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.KpiParticipantProfilesMetadataResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            tenantId = javaType.tenantId(),
            thresHolds = javaType.thresHolds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.KpiThresholdsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            unit = javaType.unit().map({ args0 -> args0 }).orElse(null),
        )
    }
}
