@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The link resource format.
 * @property description Localized descriptions for the Link.
 * @property displayName Localized display name for the Link.
 * @property id Resource ID.
 * @property linkName The link name.
 * @property mappings The set of properties mappings between the source and target Types.
 * @property name Resource name.
 * @property operationType Determines whether this link is supposed to create or delete instances if Link is NOT Reference Only.
 * @property participantPropertyReferences The properties that represent the participating profile.
 * @property provisioningState Provisioning state.
 * @property referenceOnly Indicating whether the link is reference only link. This flag is ignored if the Mappings are defined. If the mappings are not defined and it is set to true, links processing will not create or update profiles.
 * @property sourceEntityType Type of source entity.
 * @property sourceEntityTypeName Name of the source Entity Type.
 * @property targetEntityType Type of target entity.
 * @property targetEntityTypeName Name of the target Entity Type.
 * @property tenantId The hub name.
 * @property type Resource type.
 */
public data class GetLinkResult(
    public val description: Map<String, String>? = null,
    public val displayName: Map<String, String>? = null,
    public val id: String,
    public val linkName: String,
    public val mappings: List<TypePropertiesMappingResponse>? = null,
    public val name: String,
    public val operationType: String? = null,
    public val participantPropertyReferences: List<ParticipantPropertyReferenceResponse>,
    public val provisioningState: String,
    public val referenceOnly: Boolean? = null,
    public val sourceEntityType: String,
    public val sourceEntityTypeName: String,
    public val targetEntityType: String,
    public val targetEntityTypeName: String,
    public val tenantId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.GetLinkResult): GetLinkResult = GetLinkResult(
            description = javaType.description().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            displayName = javaType.displayName().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            id = javaType.id(),
            linkName = javaType.linkName(),
            mappings = javaType.mappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.TypePropertiesMappingResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            operationType = javaType.operationType().map({ args0 -> args0 }).orElse(null),
            participantPropertyReferences = javaType.participantPropertyReferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.ParticipantPropertyReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            referenceOnly = javaType.referenceOnly().map({ args0 -> args0 }).orElse(null),
            sourceEntityType = javaType.sourceEntityType(),
            sourceEntityTypeName = javaType.sourceEntityTypeName(),
            targetEntityType = javaType.targetEntityType(),
            targetEntityTypeName = javaType.targetEntityTypeName(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
        )
    }
}
