@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The prediction resource format.
 * @property autoAnalyze Whether do auto analyze.
 * @property description Description of the prediction.
 * @property displayName Display name of the prediction.
 * @property grades The prediction grades.
 * @property id Resource ID.
 * @property involvedInteractionTypes Interaction types involved in the prediction.
 * @property involvedKpiTypes KPI types involved in the prediction.
 * @property involvedRelationships Relationships involved in the prediction.
 * @property mappings Definition of the link mapping of prediction.
 * @property name Resource name.
 * @property negativeOutcomeExpression Negative outcome expression.
 * @property positiveOutcomeExpression Positive outcome expression.
 * @property predictionName Name of the prediction.
 * @property primaryProfileType Primary profile type.
 * @property provisioningState Provisioning state.
 * @property scopeExpression Scope expression.
 * @property scoreLabel Score label.
 * @property systemGeneratedEntities System generated entities.
 * @property tenantId The hub name.
 * @property type Resource type.
 */
public data class GetPredictionResult(
    public val autoAnalyze: Boolean,
    public val description: Map<String, String>? = null,
    public val displayName: Map<String, String>? = null,
    public val grades: List<PredictionResponseGrades>? = null,
    public val id: String,
    public val involvedInteractionTypes: List<String>? = null,
    public val involvedKpiTypes: List<String>? = null,
    public val involvedRelationships: List<String>? = null,
    public val mappings: PredictionResponseMappings,
    public val name: String,
    public val negativeOutcomeExpression: String,
    public val positiveOutcomeExpression: String,
    public val predictionName: String? = null,
    public val primaryProfileType: String,
    public val provisioningState: String,
    public val scopeExpression: String,
    public val scoreLabel: String,
    public val systemGeneratedEntities: PredictionResponseSystemGeneratedEntities,
    public val tenantId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.GetPredictionResult): GetPredictionResult = GetPredictionResult(
            autoAnalyze = javaType.autoAnalyze(),
            description = javaType.description().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            displayName = javaType.displayName().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            grades = javaType.grades().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.PredictionResponseGrades.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            involvedInteractionTypes = javaType.involvedInteractionTypes().map({ args0 -> args0 }),
            involvedKpiTypes = javaType.involvedKpiTypes().map({ args0 -> args0 }),
            involvedRelationships = javaType.involvedRelationships().map({ args0 -> args0 }),
            mappings = javaType.mappings().let({ args0 ->
                com.pulumi.azurenative.customerinsights.kotlin.outputs.PredictionResponseMappings.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            negativeOutcomeExpression = javaType.negativeOutcomeExpression(),
            positiveOutcomeExpression = javaType.positiveOutcomeExpression(),
            predictionName = javaType.predictionName().map({ args0 -> args0 }).orElse(null),
            primaryProfileType = javaType.primaryProfileType(),
            provisioningState = javaType.provisioningState(),
            scopeExpression = javaType.scopeExpression(),
            scoreLabel = javaType.scoreLabel(),
            systemGeneratedEntities = javaType.systemGeneratedEntities().let({ args0 ->
                com.pulumi.azurenative.customerinsights.kotlin.outputs.PredictionResponseSystemGeneratedEntities.Companion.toKotlin(args0)
            }),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
        )
    }
}
