@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The profile resource format.
 * @property apiEntitySetName The api entity set name. This becomes the odata entity set name for the entity Type being referred in this object.
 * @property attributes The attributes for the Type.
 * @property description Localized descriptions for the property.
 * @property displayName Localized display names for the property.
 * @property entityType Type of entity.
 * @property fields The properties of the Profile.
 * @property id Resource ID.
 * @property instancesCount The instance count.
 * @property largeImage Large Image associated with the Property or EntityType.
 * @property lastChangedUtc The last changed time for the type definition.
 * @property localizedAttributes Any custom localized attributes for the Type.
 * @property mediumImage Medium Image associated with the Property or EntityType.
 * @property name Resource name.
 * @property provisioningState Provisioning state.
 * @property schemaItemTypeLink The schema org link. This helps ACI identify and suggest semantic models.
 * @property smallImage Small Image associated with the Property or EntityType.
 * @property strongIds The strong IDs.
 * @property tenantId The hub name.
 * @property timestampFieldName The timestamp property name. Represents the time when the interaction or profile update happened.
 * @property type Resource type.
 * @property typeName The name of the entity.
 */
public data class GetProfileResult(
    public val apiEntitySetName: String? = null,
    public val attributes: Map<String, List<String>>? = null,
    public val description: Map<String, String>? = null,
    public val displayName: Map<String, String>? = null,
    public val entityType: String? = null,
    public val fields: List<PropertyDefinitionResponse>? = null,
    public val id: String,
    public val instancesCount: Int? = null,
    public val largeImage: String? = null,
    public val lastChangedUtc: String,
    public val localizedAttributes: Map<String, Map<String, String>>? = null,
    public val mediumImage: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val schemaItemTypeLink: String? = null,
    public val smallImage: String? = null,
    public val strongIds: List<StrongIdResponse>? = null,
    public val tenantId: String,
    public val timestampFieldName: String? = null,
    public val type: String,
    public val typeName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.GetProfileResult): GetProfileResult = GetProfileResult(
            apiEntitySetName = javaType.apiEntitySetName().map({ args0 -> args0 }).orElse(null),
            attributes = javaType.attributes().map({ args0 ->
                args0.key.to(
                    args0.value.map({ args0 ->
                        args0
                    }),
                )
            }).toMap(),
            description = javaType.description().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            displayName = javaType.displayName().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            entityType = javaType.entityType().map({ args0 -> args0 }).orElse(null),
            fields = javaType.fields().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.PropertyDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            instancesCount = javaType.instancesCount().map({ args0 -> args0 }).orElse(null),
            largeImage = javaType.largeImage().map({ args0 -> args0 }).orElse(null),
            lastChangedUtc = javaType.lastChangedUtc(),
            localizedAttributes = javaType.localizedAttributes().map({ args0 ->
                args0.key.to(args0.value.map({ args0 -> args0.key.to(args0.value) }).toMap())
            }).toMap(),
            mediumImage = javaType.mediumImage().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            schemaItemTypeLink = javaType.schemaItemTypeLink().map({ args0 -> args0 }).orElse(null),
            smallImage = javaType.smallImage().map({ args0 -> args0 }).orElse(null),
            strongIds = javaType.strongIds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.StrongIdResponse.Companion.toKotlin(args0)
                })
            }),
            tenantId = javaType.tenantId(),
            timestampFieldName = javaType.timestampFieldName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            typeName = javaType.typeName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
