@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The relationship link resource format.
 * @property description Localized descriptions for the Relationship Link.
 * @property displayName Localized display name for the Relationship Link.
 * @property id Resource ID.
 * @property interactionType The InteractionType associated with the Relationship Link.
 * @property linkName The name of the Relationship Link.
 * @property mappings The mappings between Interaction and Relationship fields.
 * @property name Resource name.
 * @property profilePropertyReferences The property references for the Profile of the Relationship.
 * @property provisioningState Provisioning state.
 * @property relatedProfilePropertyReferences The property references for the Related Profile of the Relationship.
 * @property relationshipGuidId The relationship guid id.
 * @property relationshipName The Relationship associated with the Link.
 * @property tenantId The hub name.
 * @property type Resource type.
 */
public data class GetRelationshipLinkResult(
    public val description: Map<String, String>? = null,
    public val displayName: Map<String, String>? = null,
    public val id: String,
    public val interactionType: String,
    public val linkName: String,
    public val mappings: List<RelationshipLinkFieldMappingResponse>? = null,
    public val name: String,
    public val profilePropertyReferences: List<ParticipantProfilePropertyReferenceResponse>,
    public val provisioningState: String,
    public val relatedProfilePropertyReferences: List<ParticipantProfilePropertyReferenceResponse>,
    public val relationshipGuidId: String,
    public val relationshipName: String,
    public val tenantId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.GetRelationshipLinkResult): GetRelationshipLinkResult = GetRelationshipLinkResult(
            description = javaType.description().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            displayName = javaType.displayName().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            id = javaType.id(),
            interactionType = javaType.interactionType(),
            linkName = javaType.linkName(),
            mappings = javaType.mappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.RelationshipLinkFieldMappingResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            profilePropertyReferences = javaType.profilePropertyReferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.ParticipantProfilePropertyReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            relatedProfilePropertyReferences = javaType.relatedProfilePropertyReferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.ParticipantProfilePropertyReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            relationshipGuidId = javaType.relationshipGuidId(),
            relationshipName = javaType.relationshipName(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
        )
    }
}
