@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The relationship resource format.
 * @property cardinality The Relationship Cardinality.
 * @property description Localized descriptions for the Relationship.
 * @property displayName Localized display name for the Relationship.
 * @property expiryDateTimeUtc The expiry date time in UTC.
 * @property fields The properties of the Relationship.
 * @property id Resource ID.
 * @property lookupMappings Optional property to be used to map fields in profile to their strong ids in related profile.
 * @property name Resource name.
 * @property profileType Profile type.
 * @property provisioningState Provisioning state.
 * @property relatedProfileType Related profile being referenced.
 * @property relationshipGuidId The relationship guid id.
 * @property relationshipName The Relationship name.
 * @property tenantId The hub name.
 * @property type Resource type.
 */
public data class GetRelationshipResult(
    public val cardinality: String? = null,
    public val description: Map<String, String>? = null,
    public val displayName: Map<String, String>? = null,
    public val expiryDateTimeUtc: String? = null,
    public val fields: List<PropertyDefinitionResponse>? = null,
    public val id: String,
    public val lookupMappings: List<RelationshipTypeMappingResponse>? = null,
    public val name: String,
    public val profileType: String,
    public val provisioningState: String,
    public val relatedProfileType: String,
    public val relationshipGuidId: String,
    public val relationshipName: String,
    public val tenantId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.GetRelationshipResult): GetRelationshipResult = GetRelationshipResult(
            cardinality = javaType.cardinality().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            displayName = javaType.displayName().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            expiryDateTimeUtc = javaType.expiryDateTimeUtc().map({ args0 -> args0 }).orElse(null),
            fields = javaType.fields().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.PropertyDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            lookupMappings = javaType.lookupMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.RelationshipTypeMappingResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            profileType = javaType.profileType(),
            provisioningState = javaType.provisioningState(),
            relatedProfileType = javaType.relatedProfileType(),
            relationshipGuidId = javaType.relationshipGuidId(),
            relationshipName = javaType.relationshipName(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
        )
    }
}
