@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The Role Assignment resource format.
 * @property assignmentName The name of the metadata object.
 * @property conflationPolicies Widget types set for the assignment.
 * @property connectors Connectors set for the assignment.
 * @property description Localized description for the metadata.
 * @property displayName Localized display names for the metadata.
 * @property id Resource ID.
 * @property interactions Interactions set for the assignment.
 * @property kpis Kpis set for the assignment.
 * @property links Links set for the assignment.
 * @property name Resource name.
 * @property principals The principals being assigned to.
 * @property profiles Profiles set for the assignment.
 * @property provisioningState Provisioning state.
 * @property relationshipLinks The Role assignments set for the relationship links.
 * @property relationships The Role assignments set for the relationships.
 * @property role Type of roles.
 * @property roleAssignments The Role assignments set for the assignment.
 * @property sasPolicies Sas Policies set for the assignment.
 * @property segments The Role assignments set for the assignment.
 * @property tenantId The hub name.
 * @property type Resource type.
 * @property views Views set for the assignment.
 * @property widgetTypes Widget types set for the assignment.
 */
public data class GetRoleAssignmentResult(
    public val assignmentName: String,
    public val conflationPolicies: ResourceSetDescriptionResponse? = null,
    public val connectors: ResourceSetDescriptionResponse? = null,
    public val description: Map<String, String>? = null,
    public val displayName: Map<String, String>? = null,
    public val id: String,
    public val interactions: ResourceSetDescriptionResponse? = null,
    public val kpis: ResourceSetDescriptionResponse? = null,
    public val links: ResourceSetDescriptionResponse? = null,
    public val name: String,
    public val principals: List<AssignmentPrincipalResponse>,
    public val profiles: ResourceSetDescriptionResponse? = null,
    public val provisioningState: String,
    public val relationshipLinks: ResourceSetDescriptionResponse? = null,
    public val relationships: ResourceSetDescriptionResponse? = null,
    public val role: String,
    public val roleAssignments: ResourceSetDescriptionResponse? = null,
    public val sasPolicies: ResourceSetDescriptionResponse? = null,
    public val segments: ResourceSetDescriptionResponse? = null,
    public val tenantId: String,
    public val type: String,
    public val views: ResourceSetDescriptionResponse? = null,
    public val widgetTypes: ResourceSetDescriptionResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.GetRoleAssignmentResult): GetRoleAssignmentResult = GetRoleAssignmentResult(
            assignmentName = javaType.assignmentName(),
            conflationPolicies = javaType.conflationPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.ResourceSetDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            connectors = javaType.connectors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.ResourceSetDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            displayName = javaType.displayName().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            id = javaType.id(),
            interactions = javaType.interactions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.ResourceSetDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kpis = javaType.kpis().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.ResourceSetDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            links = javaType.links().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.ResourceSetDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            principals = javaType.principals().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.AssignmentPrincipalResponse.Companion.toKotlin(args0)
                })
            }),
            profiles = javaType.profiles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.ResourceSetDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            relationshipLinks = javaType.relationshipLinks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.ResourceSetDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            relationships = javaType.relationships().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.ResourceSetDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            role = javaType.role(),
            roleAssignments = javaType.roleAssignments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.ResourceSetDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sasPolicies = javaType.sasPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.ResourceSetDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            segments = javaType.segments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.ResourceSetDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
            views = javaType.views().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.ResourceSetDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            widgetTypes = javaType.widgetTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.ResourceSetDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
