@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The view resource format.
 * @property changed Date time when view was last modified.
 * @property created Date time when view was created.
 * @property definition View definition.
 * @property displayName Localized display name for the view.
 * @property id Resource ID.
 * @property name Resource name.
 * @property tenantId the hub name.
 * @property type Resource type.
 * @property userId the user ID.
 * @property viewName Name of the view.
 */
public data class GetViewResult(
    public val changed: String,
    public val created: String,
    public val definition: String,
    public val displayName: Map<String, String>? = null,
    public val id: String,
    public val name: String,
    public val tenantId: String,
    public val type: String,
    public val userId: String? = null,
    public val viewName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.GetViewResult): GetViewResult = GetViewResult(
            changed = javaType.changed(),
            created = javaType.created(),
            definition = javaType.definition(),
            displayName = javaType.displayName().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            id = javaType.id(),
            name = javaType.name(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
            userId = javaType.userId().map({ args0 -> args0 }).orElse(null),
            viewName = javaType.viewName(),
        )
    }
}
