@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Hub billing info.
 * @property maxUnits The maximum number of units can be used.  One unit is 10,000 Profiles and 100,000 Interactions.
 * @property minUnits The minimum number of units will be billed. One unit is 10,000 Profiles and 100,000 Interactions.
 * @property skuName The sku name.
 */
public data class HubBillingInfoFormatResponse(
    public val maxUnits: Int? = null,
    public val minUnits: Int? = null,
    public val skuName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.HubBillingInfoFormatResponse): HubBillingInfoFormatResponse = HubBillingInfoFormatResponse(
            maxUnits = javaType.maxUnits().map({ args0 -> args0 }).orElse(null),
            minUnits = javaType.minUnits().map({ args0 -> args0 }).orElse(null),
            skuName = javaType.skuName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
