@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The KPI GroupBy field metadata.
 * @property displayName The display name.
 * @property fieldName The name of the field.
 * @property fieldType The type of the field.
 */
public data class KpiGroupByMetadataResponse(
    public val displayName: Map<String, String>? = null,
    public val fieldName: String? = null,
    public val fieldType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.KpiGroupByMetadataResponse): KpiGroupByMetadataResponse = KpiGroupByMetadataResponse(
            displayName = javaType.displayName().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            fieldName = javaType.fieldName().map({ args0 -> args0 }).orElse(null),
            fieldType = javaType.fieldType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
