@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress

/**
 * Defines the KPI Threshold limits.
 * @property increasingKpi Whether or not the KPI is an increasing KPI.
 * @property lowerLimit The lower threshold limit.
 * @property upperLimit The upper threshold limit.
 */
public data class KpiThresholdsResponse(
    public val increasingKpi: Boolean,
    public val lowerLimit: Double,
    public val upperLimit: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.KpiThresholdsResponse): KpiThresholdsResponse = KpiThresholdsResponse(
            increasingKpi = javaType.increasingKpi(),
            lowerLimit = javaType.lowerLimit(),
            upperLimit = javaType.upperLimit(),
        )
    }
}
