@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The participant profile property reference.
 * @property interactionPropertyName The source interaction property that maps to the target profile property.
 * @property profilePropertyName The target profile property that maps to the source interaction property.
 */
public data class ParticipantProfilePropertyReferenceResponse(
    public val interactionPropertyName: String,
    public val profilePropertyName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.ParticipantProfilePropertyReferenceResponse): ParticipantProfilePropertyReferenceResponse = ParticipantProfilePropertyReferenceResponse(
            interactionPropertyName = javaType.interactionPropertyName(),
            profilePropertyName = javaType.profilePropertyName(),
        )
    }
}
