@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The participant property reference.
 * @property sourcePropertyName The source property that maps to the target property.
 * @property targetPropertyName The target property that maps to the source property.
 */
public data class ParticipantPropertyReferenceResponse(
    public val sourcePropertyName: String,
    public val targetPropertyName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.ParticipantPropertyReferenceResponse): ParticipantPropertyReferenceResponse = ParticipantPropertyReferenceResponse(
            sourcePropertyName = javaType.sourcePropertyName(),
            targetPropertyName = javaType.targetPropertyName(),
        )
    }
}
