@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Double
import kotlin.Suppress
import kotlin.collections.List

/**
 * The definition of the prediction distribution.
 * @property distributions Distributions of the prediction.
 * @property totalNegatives Total negatives in the distribution.
 * @property totalPositives Total positive in the distribution.
 */
public data class PredictionDistributionDefinitionResponse(
    public val distributions: List<PredictionDistributionDefinitionResponseDistributions>? = null,
    public val totalNegatives: Double? = null,
    public val totalPositives: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.PredictionDistributionDefinitionResponse): PredictionDistributionDefinitionResponse = PredictionDistributionDefinitionResponse(
            distributions = javaType.distributions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.PredictionDistributionDefinitionResponseDistributions.Companion.toKotlin(args0)
                })
            }),
            totalNegatives = javaType.totalNegatives().map({ args0 -> args0 }).orElse(null),
            totalPositives = javaType.totalPositives().map({ args0 -> args0 }).orElse(null),
        )
    }
}
