@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The definition of a prediction grade.
 * @property gradeName Name of the grade.
 * @property maxScoreThreshold Maximum score threshold.
 * @property minScoreThreshold Minimum score threshold.
 */
public data class PredictionResponseGrades(
    public val gradeName: String? = null,
    public val maxScoreThreshold: Int? = null,
    public val minScoreThreshold: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.PredictionResponseGrades): PredictionResponseGrades = PredictionResponseGrades(
            gradeName = javaType.gradeName().map({ args0 -> args0 }).orElse(null),
            maxScoreThreshold = javaType.maxScoreThreshold().map({ args0 -> args0 }).orElse(null),
            minScoreThreshold = javaType.minScoreThreshold().map({ args0 -> args0 }).orElse(null),
        )
    }
}
