@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Map a field of profile to its corresponding StrongId in Related Profile.
 * @property profileFieldName Specifies the fieldName in profile.
 * @property relatedProfileKeyProperty Specifies the KeyProperty (from StrongId) of the related profile.
 */
public data class RelationshipTypeFieldMappingResponse(
    public val profileFieldName: String,
    public val relatedProfileKeyProperty: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.RelationshipTypeFieldMappingResponse): RelationshipTypeFieldMappingResponse = RelationshipTypeFieldMappingResponse(
            profileFieldName = javaType.profileFieldName(),
            relatedProfileKeyProperty = javaType.relatedProfileKeyProperty(),
        )
    }
}
