@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The resource set description.
 * @property elements The elements included in the set.
 * @property exceptions The elements that are not included in the set, in case elements contains '*' indicating 'all'.
 */
public data class ResourceSetDescriptionResponse(
    public val elements: List<String>? = null,
    public val exceptions: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.ResourceSetDescriptionResponse): ResourceSetDescriptionResponse = ResourceSetDescriptionResponse(
            elements = javaType.elements().map({ args0 -> args0 }),
            exceptions = javaType.exceptions().map({ args0 -> args0 }),
        )
    }
}
