@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Property/Properties which represent a unique ID.
 * @property description Localized descriptions.
 * @property displayName Localized display name.
 * @property keyPropertyNames The properties which make up the unique ID.
 * @property strongIdName The Name identifying the strong ID.
 */
public data class StrongIdResponse(
    public val description: Map<String, String>? = null,
    public val displayName: Map<String, String>? = null,
    public val keyPropertyNames: List<String>,
    public val strongIdName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.StrongIdResponse): StrongIdResponse = StrongIdResponse(
            description = javaType.description().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            displayName = javaType.displayName().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            keyPropertyNames = javaType.keyPropertyNames().map({ args0 -> args0 }),
            strongIdName = javaType.strongIdName(),
        )
    }
}
