@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customproviders.kotlin

import com.pulumi.azurenative.customproviders.CustomprovidersFunctions.getAssociationPlain
import com.pulumi.azurenative.customproviders.CustomprovidersFunctions.getCustomResourceProviderPlain
import com.pulumi.azurenative.customproviders.kotlin.inputs.GetAssociationPlainArgs
import com.pulumi.azurenative.customproviders.kotlin.inputs.GetAssociationPlainArgsBuilder
import com.pulumi.azurenative.customproviders.kotlin.inputs.GetCustomResourceProviderPlainArgs
import com.pulumi.azurenative.customproviders.kotlin.inputs.GetCustomResourceProviderPlainArgsBuilder
import com.pulumi.azurenative.customproviders.kotlin.outputs.GetAssociationResult
import com.pulumi.azurenative.customproviders.kotlin.outputs.GetCustomResourceProviderResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.customproviders.kotlin.outputs.GetAssociationResult.Companion.toKotlin as getAssociationResultToKotlin
import com.pulumi.azurenative.customproviders.kotlin.outputs.GetCustomResourceProviderResult.Companion.toKotlin as getCustomResourceProviderResultToKotlin

public object CustomprovidersFunctions {
    /**
     * Get an association.
     * Azure REST API version: 2018-09-01-preview.
     * @param argument null
     * @return The resource definition of this association.
     */
    public suspend fun getAssociation(argument: GetAssociationPlainArgs): GetAssociationResult =
        getAssociationResultToKotlin(getAssociationPlain(argument.toJava()).await())

    /**
     * @see [getAssociation].
     * @param associationName The name of the association.
     * @param scope The scope of the association.
     * @return The resource definition of this association.
     */
    public suspend fun getAssociation(associationName: String, scope: String): GetAssociationResult {
        val argument = GetAssociationPlainArgs(
            associationName = associationName,
            scope = scope,
        )
        return getAssociationResultToKotlin(getAssociationPlain(argument.toJava()).await())
    }

    /**
     * @see [getAssociation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;customproviders&#46;kotlin&#46;inputs&#46;GetAssociationPlainArgs].
     * @return The resource definition of this association.
     */
    public suspend fun getAssociation(argument: suspend GetAssociationPlainArgsBuilder.() -> Unit): GetAssociationResult {
        val builder = GetAssociationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAssociationResultToKotlin(getAssociationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the custom resource provider manifest.
     * Azure REST API version: 2018-09-01-preview.
     * @param argument null
     * @return A manifest file that defines the custom resource provider resources.
     */
    public suspend fun getCustomResourceProvider(argument: GetCustomResourceProviderPlainArgs): GetCustomResourceProviderResult =
        getCustomResourceProviderResultToKotlin(getCustomResourceProviderPlain(argument.toJava()).await())

    /**
     * @see [getCustomResourceProvider].
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderName The name of the resource provider.
     * @return A manifest file that defines the custom resource provider resources.
     */
    public suspend fun getCustomResourceProvider(
        resourceGroupName: String,
        resourceProviderName: String,
    ): GetCustomResourceProviderResult {
        val argument = GetCustomResourceProviderPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceProviderName = resourceProviderName,
        )
        return getCustomResourceProviderResultToKotlin(getCustomResourceProviderPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomResourceProvider].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;customproviders&#46;kotlin&#46;inputs&#46;GetCustomResourceProviderPlainArgs].
     * @return A manifest file that defines the custom resource provider resources.
     */
    public suspend fun getCustomResourceProvider(argument: suspend GetCustomResourceProviderPlainArgsBuilder.() -> Unit): GetCustomResourceProviderResult {
        val builder = GetCustomResourceProviderPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomResourceProviderResultToKotlin(getCustomResourceProviderPlain(builtArgument.toJava()).await())
    }
}
