@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customproviders.kotlin.inputs

import com.pulumi.azurenative.customproviders.inputs.CustomRPActionRouteDefinitionArgs.builder
import com.pulumi.azurenative.customproviders.kotlin.enums.ActionRouting
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The route definition for an action implemented by the custom resource provider.
 * @property endpoint The route definition endpoint URI that the custom resource provider will proxy requests to. This can be in the form of a flat URI (e.g. 'https://testendpoint/') or can specify to route via a path (e.g. 'https://testendpoint/{requestPath}')
 * @property name The name of the route definition. This becomes the name for the ARM extension (e.g. '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomProviders/resourceProviders/{resourceProviderName}/{name}')
 * @property routingType The routing types that are supported for action requests.
 */
public data class CustomRPActionRouteDefinitionArgs(
    public val endpoint: Output<String>,
    public val name: Output<String>,
    public val routingType: Output<Either<String, ActionRouting>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.customproviders.inputs.CustomRPActionRouteDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.customproviders.inputs.CustomRPActionRouteDefinitionArgs =
        com.pulumi.azurenative.customproviders.inputs.CustomRPActionRouteDefinitionArgs.builder()
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .routingType(
                routingType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [CustomRPActionRouteDefinitionArgs].
 */
@PulumiTagMarker
public class CustomRPActionRouteDefinitionArgsBuilder internal constructor() {
    private var endpoint: Output<String>? = null

    private var name: Output<String>? = null

    private var routingType: Output<Either<String, ActionRouting>>? = null

    /**
     * @param value The route definition endpoint URI that the custom resource provider will proxy requests to. This can be in the form of a flat URI (e.g. 'https://testendpoint/') or can specify to route via a path (e.g. 'https://testendpoint/{requestPath}')
     */
    @JvmName("uawlvxjmffyigacj")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value The name of the route definition. This becomes the name for the ARM extension (e.g. '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomProviders/resourceProviders/{resourceProviderName}/{name}')
     */
    @JvmName("avgueclvcvsdhfvf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The routing types that are supported for action requests.
     */
    @JvmName("auksolordqobdkfq")
    public suspend fun routingType(`value`: Output<Either<String, ActionRouting>>) {
        this.routingType = value
    }

    /**
     * @param value The route definition endpoint URI that the custom resource provider will proxy requests to. This can be in the form of a flat URI (e.g. 'https://testendpoint/') or can specify to route via a path (e.g. 'https://testendpoint/{requestPath}')
     */
    @JvmName("bnalixuengmbneym")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value The name of the route definition. This becomes the name for the ARM extension (e.g. '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomProviders/resourceProviders/{resourceProviderName}/{name}')
     */
    @JvmName("qjdcelyjvqchfyjr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The routing types that are supported for action requests.
     */
    @JvmName("hlrsmmpkpflhbyxk")
    public suspend fun routingType(`value`: Either<String, ActionRouting>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingType = mapped
    }

    /**
     * @param value The routing types that are supported for action requests.
     */
    @JvmName("sfdfmdsdildjsooh")
    public fun routingType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActionRouting>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingType = mapped
    }

    /**
     * @param value The routing types that are supported for action requests.
     */
    @JvmName("vieuvukdtbvfdqie")
    public fun routingType(`value`: ActionRouting) {
        val toBeMapped = Either.ofRight<String, ActionRouting>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingType = mapped
    }

    internal fun build(): CustomRPActionRouteDefinitionArgs = CustomRPActionRouteDefinitionArgs(
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
        name = name ?: throw PulumiNullFieldException("name"),
        routingType = routingType,
    )
}
