@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customproviders.kotlin.inputs

import com.pulumi.azurenative.customproviders.inputs.CustomRPValidationsArgs.builder
import com.pulumi.azurenative.customproviders.kotlin.enums.ValidationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A validation to apply on custom resource provider requests.
 * @property specification A link to the validation specification. The specification must be hosted on raw.githubusercontent.com.
 * @property validationType The type of validation to run against a matching request.
 */
public data class CustomRPValidationsArgs(
    public val specification: Output<String>,
    public val validationType: Output<Either<String, ValidationType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.customproviders.inputs.CustomRPValidationsArgs> {
    override fun toJava(): com.pulumi.azurenative.customproviders.inputs.CustomRPValidationsArgs =
        com.pulumi.azurenative.customproviders.inputs.CustomRPValidationsArgs.builder()
            .specification(specification.applyValue({ args0 -> args0 }))
            .validationType(
                validationType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [CustomRPValidationsArgs].
 */
@PulumiTagMarker
public class CustomRPValidationsArgsBuilder internal constructor() {
    private var specification: Output<String>? = null

    private var validationType: Output<Either<String, ValidationType>>? = null

    /**
     * @param value A link to the validation specification. The specification must be hosted on raw.githubusercontent.com.
     */
    @JvmName("eylmvpmoonwcycet")
    public suspend fun specification(`value`: Output<String>) {
        this.specification = value
    }

    /**
     * @param value The type of validation to run against a matching request.
     */
    @JvmName("lxptxdsfqvsqgxtx")
    public suspend fun validationType(`value`: Output<Either<String, ValidationType>>) {
        this.validationType = value
    }

    /**
     * @param value A link to the validation specification. The specification must be hosted on raw.githubusercontent.com.
     */
    @JvmName("fmxipwfmqewnhhmy")
    public suspend fun specification(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.specification = mapped
    }

    /**
     * @param value The type of validation to run against a matching request.
     */
    @JvmName("xjoillgjfcfreslv")
    public suspend fun validationType(`value`: Either<String, ValidationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationType = mapped
    }

    /**
     * @param value The type of validation to run against a matching request.
     */
    @JvmName("hxmauemwkpjoktpi")
    public fun validationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ValidationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validationType = mapped
    }

    /**
     * @param value The type of validation to run against a matching request.
     */
    @JvmName("yuthcfotoqhdibve")
    public fun validationType(`value`: ValidationType) {
        val toBeMapped = Either.ofRight<String, ValidationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validationType = mapped
    }

    internal fun build(): CustomRPValidationsArgs = CustomRPValidationsArgs(
        specification = specification ?: throw PulumiNullFieldException("specification"),
        validationType = validationType,
    )
}
