@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customproviders.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The resource definition of this association.
 * @property id The association id.
 * @property name The association name.
 * @property provisioningState The provisioning state of the association.
 * @property targetResourceId The REST resource instance of the target resource for this association.
 * @property type The association type.
 */
public data class GetAssociationResult(
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val targetResourceId: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customproviders.outputs.GetAssociationResult): GetAssociationResult = GetAssociationResult(
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            targetResourceId = javaType.targetResourceId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
