@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customproviders.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A manifest file that defines the custom resource provider resources.
 * @property actions A list of actions that the custom resource provider implements.
 * @property id Resource Id
 * @property location Resource location
 * @property name Resource name
 * @property provisioningState The provisioning state of the resource provider.
 * @property resourceTypes A list of resource types that the custom resource provider implements.
 * @property tags Resource tags
 * @property type Resource type
 * @property validations A list of validations to run on the custom resource provider's requests.
 */
public data class GetCustomResourceProviderResult(
    public val actions: List<CustomRPActionRouteDefinitionResponse>? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val resourceTypes: List<CustomRPResourceTypeRouteDefinitionResponse>? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val validations: List<CustomRPValidationsResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.customproviders.outputs.GetCustomResourceProviderResult): GetCustomResourceProviderResult = GetCustomResourceProviderResult(
            actions = javaType.actions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customproviders.kotlin.outputs.CustomRPActionRouteDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            resourceTypes = javaType.resourceTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customproviders.kotlin.outputs.CustomRPResourceTypeRouteDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            validations = javaType.validations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customproviders.kotlin.outputs.CustomRPValidationsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
