@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dashboard.kotlin

import com.pulumi.azurenative.dashboard.DashboardFunctions.getGrafanaPlain
import com.pulumi.azurenative.dashboard.DashboardFunctions.getManagedPrivateEndpointPlain
import com.pulumi.azurenative.dashboard.DashboardFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.dashboard.kotlin.inputs.GetGrafanaPlainArgs
import com.pulumi.azurenative.dashboard.kotlin.inputs.GetGrafanaPlainArgsBuilder
import com.pulumi.azurenative.dashboard.kotlin.inputs.GetManagedPrivateEndpointPlainArgs
import com.pulumi.azurenative.dashboard.kotlin.inputs.GetManagedPrivateEndpointPlainArgsBuilder
import com.pulumi.azurenative.dashboard.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.dashboard.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.dashboard.kotlin.outputs.GetGrafanaResult
import com.pulumi.azurenative.dashboard.kotlin.outputs.GetManagedPrivateEndpointResult
import com.pulumi.azurenative.dashboard.kotlin.outputs.GetPrivateEndpointConnectionResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.dashboard.kotlin.outputs.GetGrafanaResult.Companion.toKotlin as getGrafanaResultToKotlin
import com.pulumi.azurenative.dashboard.kotlin.outputs.GetManagedPrivateEndpointResult.Companion.toKotlin as getManagedPrivateEndpointResultToKotlin
import com.pulumi.azurenative.dashboard.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin

public object DashboardFunctions {
    /**
     * The grafana resource type.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2021-09-01-preview, 2022-10-01-preview, 2023-09-01.
     * @param argument null
     * @return The grafana resource type.
     */
    public suspend fun getGrafana(argument: GetGrafanaPlainArgs): GetGrafanaResult =
        getGrafanaResultToKotlin(getGrafanaPlain(argument.toJava()).await())

    /**
     * @see [getGrafana].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The workspace name of Azure Managed Grafana.
     * @return The grafana resource type.
     */
    public suspend fun getGrafana(resourceGroupName: String, workspaceName: String): GetGrafanaResult {
        val argument = GetGrafanaPlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getGrafanaResultToKotlin(getGrafanaPlain(argument.toJava()).await())
    }

    /**
     * @see [getGrafana].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dashboard&#46;kotlin&#46;inputs&#46;GetGrafanaPlainArgs].
     * @return The grafana resource type.
     */
    public suspend fun getGrafana(argument: suspend GetGrafanaPlainArgsBuilder.() -> Unit): GetGrafanaResult {
        val builder = GetGrafanaPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGrafanaResultToKotlin(getGrafanaPlain(builtArgument.toJava()).await())
    }

    /**
     * The managed private endpoint resource type.
     * Azure REST API version: 2022-10-01-preview.
     * Other available API versions: 2023-09-01.
     * @param argument null
     * @return The managed private endpoint resource type.
     */
    public suspend fun getManagedPrivateEndpoint(argument: GetManagedPrivateEndpointPlainArgs): GetManagedPrivateEndpointResult =
        getManagedPrivateEndpointResultToKotlin(getManagedPrivateEndpointPlain(argument.toJava()).await())

    /**
     * @see [getManagedPrivateEndpoint].
     * @param managedPrivateEndpointName The managed private endpoint name of Azure Managed Grafana.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The workspace name of Azure Managed Grafana.
     * @return The managed private endpoint resource type.
     */
    public suspend fun getManagedPrivateEndpoint(
        managedPrivateEndpointName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetManagedPrivateEndpointResult {
        val argument = GetManagedPrivateEndpointPlainArgs(
            managedPrivateEndpointName = managedPrivateEndpointName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getManagedPrivateEndpointResultToKotlin(getManagedPrivateEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedPrivateEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dashboard&#46;kotlin&#46;inputs&#46;GetManagedPrivateEndpointPlainArgs].
     * @return The managed private endpoint resource type.
     */
    public suspend fun getManagedPrivateEndpoint(argument: suspend GetManagedPrivateEndpointPlainArgsBuilder.() -> Unit): GetManagedPrivateEndpointResult {
        val builder = GetManagedPrivateEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedPrivateEndpointResultToKotlin(getManagedPrivateEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     * The Private Endpoint Connection resource.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2022-10-01-preview, 2023-09-01.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs): GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName The private endpoint connection name of Azure Managed Grafana.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The workspace name of Azure Managed Grafana.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dashboard&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit): GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }
}
