@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dashboard.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The managed private endpoint resource type.
 * @property connectionState The state of managed private endpoint connection.
 * @property groupIds The group Ids of the managed private endpoint.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property privateLinkResourceId The ARM resource ID of the resource for which the managed private endpoint is pointing to.
 * @property privateLinkResourceRegion The region of the resource to which the managed private endpoint is pointing to.
 * @property privateLinkServicePrivateIP The private IP of private endpoint after approval. This property is empty before connection is approved.
 * @property privateLinkServiceUrl The URL of the data store behind the private link service. It would be the URL in the Grafana data source configuration page without the protocol and port.
 * @property provisioningState Provisioning state of the resource.
 * @property requestMessage User input request message of the managed private endpoint.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetManagedPrivateEndpointResult(
    public val connectionState: ManagedPrivateEndpointConnectionStateResponse,
    public val groupIds: List<String>? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val privateLinkResourceId: String? = null,
    public val privateLinkResourceRegion: String? = null,
    public val privateLinkServicePrivateIP: String,
    public val privateLinkServiceUrl: String? = null,
    public val provisioningState: String,
    public val requestMessage: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dashboard.outputs.GetManagedPrivateEndpointResult): GetManagedPrivateEndpointResult = GetManagedPrivateEndpointResult(
            connectionState = javaType.connectionState().let({ args0 ->
                com.pulumi.azurenative.dashboard.kotlin.outputs.ManagedPrivateEndpointConnectionStateResponse.Companion.toKotlin(args0)
            }),
            groupIds = javaType.groupIds().map({ args0 -> args0 }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            privateLinkResourceId = javaType.privateLinkResourceId().map({ args0 -> args0 }).orElse(null),
            privateLinkResourceRegion = javaType.privateLinkResourceRegion().map({ args0 ->
                args0
            }).orElse(null),
            privateLinkServicePrivateIP = javaType.privateLinkServicePrivateIP(),
            privateLinkServiceUrl = javaType.privateLinkServiceUrl().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            requestMessage = javaType.requestMessage().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.dashboard.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
