@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dashboard.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties specific to the grafana resource.
 * @property apiKey The api key setting of the Grafana instance.
 * @property autoGeneratedDomainNameLabelScope Scope for dns deterministic name hash calculation.
 * @property deterministicOutboundIP Whether a Grafana instance uses deterministic outbound IPs.
 * @property endpoint The endpoint of the Grafana instance.
 * @property grafanaIntegrations GrafanaIntegrations is a bundled observability experience (e.g. pre-configured data source, tailored Grafana dashboards, alerting defaults) for common monitoring scenarios.
 * @property grafanaVersion The Grafana software version.
 * @property outboundIPs List of outbound IPs if deterministicOutboundIP is enabled.
 * @property privateEndpointConnections The private endpoint connections of the Grafana instance.
 * @property provisioningState Provisioning state of the resource.
 * @property publicNetworkAccess Indicate the state for enable or disable traffic over the public interface.
 * @property zoneRedundancy The zone redundancy setting of the Grafana instance.
 */
public data class ManagedGrafanaPropertiesResponse(
    public val apiKey: String? = null,
    public val autoGeneratedDomainNameLabelScope: String? = null,
    public val deterministicOutboundIP: String? = null,
    public val endpoint: String,
    public val grafanaIntegrations: GrafanaIntegrationsResponse? = null,
    public val grafanaVersion: String,
    public val outboundIPs: List<String>,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val zoneRedundancy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dashboard.outputs.ManagedGrafanaPropertiesResponse): ManagedGrafanaPropertiesResponse = ManagedGrafanaPropertiesResponse(
            apiKey = javaType.apiKey().map({ args0 -> args0 }).orElse(null),
            autoGeneratedDomainNameLabelScope = javaType.autoGeneratedDomainNameLabelScope().map({ args0 ->
                args0
            }).orElse(null),
            deterministicOutboundIP = javaType.deterministicOutboundIP().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint(),
            grafanaIntegrations = javaType.grafanaIntegrations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dashboard.kotlin.outputs.GrafanaIntegrationsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            grafanaVersion = javaType.grafanaVersion(),
            outboundIPs = javaType.outboundIPs().map({ args0 -> args0 }),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dashboard.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            zoneRedundancy = javaType.zoneRedundancy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
