@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dashboard.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The state of managed private endpoint connection.
 * @property description Gets or sets the reason for approval/rejection of the connection.
 * @property status The approval/rejection status of managed private endpoint connection.
 */
public data class ManagedPrivateEndpointConnectionStateResponse(
    public val description: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dashboard.outputs.ManagedPrivateEndpointConnectionStateResponse): ManagedPrivateEndpointConnectionStateResponse =
            ManagedPrivateEndpointConnectionStateResponse(
                description = javaType.description(),
                status = javaType.status(),
            )
    }
}
