@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databasewatcher.kotlin

import com.pulumi.azurenative.databasewatcher.DatabasewatcherFunctions.getSharedPrivateLinkResourcePlain
import com.pulumi.azurenative.databasewatcher.DatabasewatcherFunctions.getTargetPlain
import com.pulumi.azurenative.databasewatcher.DatabasewatcherFunctions.getWatcherPlain
import com.pulumi.azurenative.databasewatcher.kotlin.inputs.GetSharedPrivateLinkResourcePlainArgs
import com.pulumi.azurenative.databasewatcher.kotlin.inputs.GetSharedPrivateLinkResourcePlainArgsBuilder
import com.pulumi.azurenative.databasewatcher.kotlin.inputs.GetTargetPlainArgs
import com.pulumi.azurenative.databasewatcher.kotlin.inputs.GetTargetPlainArgsBuilder
import com.pulumi.azurenative.databasewatcher.kotlin.inputs.GetWatcherPlainArgs
import com.pulumi.azurenative.databasewatcher.kotlin.inputs.GetWatcherPlainArgsBuilder
import com.pulumi.azurenative.databasewatcher.kotlin.outputs.GetSharedPrivateLinkResourceResult
import com.pulumi.azurenative.databasewatcher.kotlin.outputs.GetTargetResult
import com.pulumi.azurenative.databasewatcher.kotlin.outputs.GetWatcherResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.databasewatcher.kotlin.outputs.GetSharedPrivateLinkResourceResult.Companion.toKotlin as getSharedPrivateLinkResourceResultToKotlin
import com.pulumi.azurenative.databasewatcher.kotlin.outputs.GetTargetResult.Companion.toKotlin as getTargetResultToKotlin
import com.pulumi.azurenative.databasewatcher.kotlin.outputs.GetWatcherResult.Companion.toKotlin as getWatcherResultToKotlin

public object DatabasewatcherFunctions {
    /**
     * Get a SharedPrivateLinkResource
     * Azure REST API version: 2023-09-01-preview.
     * @param argument null
     * @return Concrete proxy resource types can be created by aliasing this type using a specific property type.
     */
    public suspend fun getSharedPrivateLinkResource(argument: GetSharedPrivateLinkResourcePlainArgs): GetSharedPrivateLinkResourceResult =
        getSharedPrivateLinkResourceResultToKotlin(getSharedPrivateLinkResourcePlain(argument.toJava()).await())

    /**
     * @see [getSharedPrivateLinkResource].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sharedPrivateLinkResourceName The Shared Private Link resource name.
     * @param watcherName The database watcher name.
     * @return Concrete proxy resource types can be created by aliasing this type using a specific property type.
     */
    public suspend fun getSharedPrivateLinkResource(
        resourceGroupName: String,
        sharedPrivateLinkResourceName: String,
        watcherName: String,
    ): GetSharedPrivateLinkResourceResult {
        val argument = GetSharedPrivateLinkResourcePlainArgs(
            resourceGroupName = resourceGroupName,
            sharedPrivateLinkResourceName = sharedPrivateLinkResourceName,
            watcherName = watcherName,
        )
        return getSharedPrivateLinkResourceResultToKotlin(getSharedPrivateLinkResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getSharedPrivateLinkResource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databasewatcher&#46;kotlin&#46;inputs&#46;GetSharedPrivateLinkResourcePlainArgs].
     * @return Concrete proxy resource types can be created by aliasing this type using a specific property type.
     */
    public suspend fun getSharedPrivateLinkResource(argument: suspend GetSharedPrivateLinkResourcePlainArgsBuilder.() -> Unit): GetSharedPrivateLinkResourceResult {
        val builder = GetSharedPrivateLinkResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSharedPrivateLinkResourceResultToKotlin(getSharedPrivateLinkResourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Target
     * Azure REST API version: 2023-09-01-preview.
     * @param argument null
     * @return Concrete proxy resource types can be created by aliasing this type using a specific property type.
     */
    public suspend fun getTarget(argument: GetTargetPlainArgs): GetTargetResult =
        getTargetResultToKotlin(getTargetPlain(argument.toJava()).await())

    /**
     * @see [getTarget].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param targetName The target resource name.
     * @param watcherName The database watcher name.
     * @return Concrete proxy resource types can be created by aliasing this type using a specific property type.
     */
    public suspend fun getTarget(
        resourceGroupName: String,
        targetName: String,
        watcherName: String,
    ): GetTargetResult {
        val argument = GetTargetPlainArgs(
            resourceGroupName = resourceGroupName,
            targetName = targetName,
            watcherName = watcherName,
        )
        return getTargetResultToKotlin(getTargetPlain(argument.toJava()).await())
    }

    /**
     * @see [getTarget].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databasewatcher&#46;kotlin&#46;inputs&#46;GetTargetPlainArgs].
     * @return Concrete proxy resource types can be created by aliasing this type using a specific property type.
     */
    public suspend fun getTarget(argument: suspend GetTargetPlainArgsBuilder.() -> Unit): GetTargetResult {
        val builder = GetTargetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTargetResultToKotlin(getTargetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Watcher
     * Azure REST API version: 2023-09-01-preview.
     * @param argument null
     * @return The DatabaseWatcherProviderHub resource.
     */
    public suspend fun getWatcher(argument: GetWatcherPlainArgs): GetWatcherResult =
        getWatcherResultToKotlin(getWatcherPlain(argument.toJava()).await())

    /**
     * @see [getWatcher].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param watcherName The database watcher name.
     * @return The DatabaseWatcherProviderHub resource.
     */
    public suspend fun getWatcher(resourceGroupName: String, watcherName: String): GetWatcherResult {
        val argument = GetWatcherPlainArgs(
            resourceGroupName = resourceGroupName,
            watcherName = watcherName,
        )
        return getWatcherResultToKotlin(getWatcherPlain(argument.toJava()).await())
    }

    /**
     * @see [getWatcher].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;databasewatcher&#46;kotlin&#46;inputs&#46;GetWatcherPlainArgs].
     * @return The DatabaseWatcherProviderHub resource.
     */
    public suspend fun getWatcher(argument: suspend GetWatcherPlainArgsBuilder.() -> Unit): GetWatcherResult {
        val builder = GetWatcherPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWatcherResultToKotlin(getWatcherPlain(builtArgument.toJava()).await())
    }
}
