@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databasewatcher.kotlin

import com.pulumi.azurenative.databasewatcher.SharedPrivateLinkResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Concrete proxy resource types can be created by aliasing this type using a specific property type.
 * Azure REST API version: 2023-09-01-preview.
 * ## Example Usage
 * ### SharedPrivateLinkResources_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sharedPrivateLinkResource = new AzureNative.DatabaseWatcher.SharedPrivateLinkResource("sharedPrivateLinkResource", new()
 *     {
 *         DnsZone = "ec3ae9d410ba",
 *         GroupId = "vault",
 *         PrivateLinkResourceId = "/subscriptions/6f53185c-ea09-4fc3-9075-318dec805303/resourceGroups/apiTest-ddat4p/providers/Microsoft.KeyVault/vaults/kvmo3ej9ih",
 *         RequestMessage = "request message",
 *         ResourceGroupName = "apiTest-ddat4p",
 *         SharedPrivateLinkResourceName = "monitoringh22eed",
 *         WatcherName = "databasemo3ej9ih",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databasewatcher/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databasewatcher.NewSharedPrivateLinkResource(ctx, "sharedPrivateLinkResource", &databasewatcher.SharedPrivateLinkResourceArgs{
 * 			DnsZone:                       pulumi.String("ec3ae9d410ba"),
 * 			GroupId:                       pulumi.String("vault"),
 * 			PrivateLinkResourceId:         pulumi.String("/subscriptions/6f53185c-ea09-4fc3-9075-318dec805303/resourceGroups/apiTest-ddat4p/providers/Microsoft.KeyVault/vaults/kvmo3ej9ih"),
 * 			RequestMessage:                pulumi.String("request message"),
 * 			ResourceGroupName:             pulumi.String("apiTest-ddat4p"),
 * 			SharedPrivateLinkResourceName: pulumi.String("monitoringh22eed"),
 * 			WatcherName:                   pulumi.String("databasemo3ej9ih"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databasewatcher.SharedPrivateLinkResource;
 * import com.pulumi.azurenative.databasewatcher.SharedPrivateLinkResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sharedPrivateLinkResource = new SharedPrivateLinkResource("sharedPrivateLinkResource", SharedPrivateLinkResourceArgs.builder()
 *             .dnsZone("ec3ae9d410ba")
 *             .groupId("vault")
 *             .privateLinkResourceId("/subscriptions/6f53185c-ea09-4fc3-9075-318dec805303/resourceGroups/apiTest-ddat4p/providers/Microsoft.KeyVault/vaults/kvmo3ej9ih")
 *             .requestMessage("request message")
 *             .resourceGroupName("apiTest-ddat4p")
 *             .sharedPrivateLinkResourceName("monitoringh22eed")
 *             .watcherName("databasemo3ej9ih")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databasewatcher:SharedPrivateLinkResource monitoringh22eed /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DatabaseWatcher/watchers/{watcherName}/sharedPrivateLinkResources/{sharedPrivateLinkResourceName}
 * ```
 * @property dnsZone The DNS zone to be included in the DNS name of the shared private link. Value is service-specific.
 * @property groupId The group id from the provider of resource the shared private link resource is for.
 * @property privateLinkResourceId The resource id of the resource the shared private link resource is for.
 * @property requestMessage The request message for requesting approval of the shared private link resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sharedPrivateLinkResourceName The Shared Private Link resource name.
 * @property watcherName The database watcher name.
 */
public data class SharedPrivateLinkResourceArgs(
    public val dnsZone: Output<String>? = null,
    public val groupId: Output<String>? = null,
    public val privateLinkResourceId: Output<String>? = null,
    public val requestMessage: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sharedPrivateLinkResourceName: Output<String>? = null,
    public val watcherName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databasewatcher.SharedPrivateLinkResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.databasewatcher.SharedPrivateLinkResourceArgs =
        com.pulumi.azurenative.databasewatcher.SharedPrivateLinkResourceArgs.builder()
            .dnsZone(dnsZone?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .privateLinkResourceId(privateLinkResourceId?.applyValue({ args0 -> args0 }))
            .requestMessage(requestMessage?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sharedPrivateLinkResourceName(sharedPrivateLinkResourceName?.applyValue({ args0 -> args0 }))
            .watcherName(watcherName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SharedPrivateLinkResourceArgs].
 */
@PulumiTagMarker
public class SharedPrivateLinkResourceArgsBuilder internal constructor() {
    private var dnsZone: Output<String>? = null

    private var groupId: Output<String>? = null

    private var privateLinkResourceId: Output<String>? = null

    private var requestMessage: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sharedPrivateLinkResourceName: Output<String>? = null

    private var watcherName: Output<String>? = null

    /**
     * @param value The DNS zone to be included in the DNS name of the shared private link. Value is service-specific.
     */
    @JvmName("xrndtqmqsojbiamn")
    public suspend fun dnsZone(`value`: Output<String>) {
        this.dnsZone = value
    }

    /**
     * @param value The group id from the provider of resource the shared private link resource is for.
     */
    @JvmName("tpgyimpudftlmyao")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The resource id of the resource the shared private link resource is for.
     */
    @JvmName("dpmoywakehqxnsxp")
    public suspend fun privateLinkResourceId(`value`: Output<String>) {
        this.privateLinkResourceId = value
    }

    /**
     * @param value The request message for requesting approval of the shared private link resource.
     */
    @JvmName("ndctmxcxwhaxoqbh")
    public suspend fun requestMessage(`value`: Output<String>) {
        this.requestMessage = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("twqtxpkraerblnmr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Shared Private Link resource name.
     */
    @JvmName("vrghwfhijjrejtdb")
    public suspend fun sharedPrivateLinkResourceName(`value`: Output<String>) {
        this.sharedPrivateLinkResourceName = value
    }

    /**
     * @param value The database watcher name.
     */
    @JvmName("hqjsmwfplawadfgs")
    public suspend fun watcherName(`value`: Output<String>) {
        this.watcherName = value
    }

    /**
     * @param value The DNS zone to be included in the DNS name of the shared private link. Value is service-specific.
     */
    @JvmName("wnvrabxpuuoplsck")
    public suspend fun dnsZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsZone = mapped
    }

    /**
     * @param value The group id from the provider of resource the shared private link resource is for.
     */
    @JvmName("rkggkfvobdwxceik")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The resource id of the resource the shared private link resource is for.
     */
    @JvmName("vgplorxaklakowta")
    public suspend fun privateLinkResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkResourceId = mapped
    }

    /**
     * @param value The request message for requesting approval of the shared private link resource.
     */
    @JvmName("tcyjvmkrjymnihrq")
    public suspend fun requestMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMessage = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wjlgimasouscsshi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Shared Private Link resource name.
     */
    @JvmName("ebbbdsfvixkjaxxv")
    public suspend fun sharedPrivateLinkResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedPrivateLinkResourceName = mapped
    }

    /**
     * @param value The database watcher name.
     */
    @JvmName("ockclhlshxrkbxjw")
    public suspend fun watcherName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.watcherName = mapped
    }

    internal fun build(): SharedPrivateLinkResourceArgs = SharedPrivateLinkResourceArgs(
        dnsZone = dnsZone,
        groupId = groupId,
        privateLinkResourceId = privateLinkResourceId,
        requestMessage = requestMessage,
        resourceGroupName = resourceGroupName,
        sharedPrivateLinkResourceName = sharedPrivateLinkResourceName,
        watcherName = watcherName,
    )
}
