@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databasewatcher.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of authentication to use when connecting to a target.
 */
public enum class TargetAuthenticationType(
    public val javaValue: com.pulumi.azurenative.databasewatcher.enums.TargetAuthenticationType,
) : ConvertibleToJava<com.pulumi.azurenative.databasewatcher.enums.TargetAuthenticationType> {
    /**
     * The Azure Active Directory authentication.
     */
    Aad(com.pulumi.azurenative.databasewatcher.enums.TargetAuthenticationType.Aad),

    /**
     * The SQL password authentication.
     */
    Sql(com.pulumi.azurenative.databasewatcher.enums.TargetAuthenticationType.Sql),
    ;

    override fun toJava(): com.pulumi.azurenative.databasewatcher.enums.TargetAuthenticationType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databasewatcher.enums.TargetAuthenticationType): TargetAuthenticationType =
            TargetAuthenticationType.values().first { it.javaValue == javaType }
    }
}
